// idep_filedepiter.h
#ifndef INCLUDED_IDEP_FILEDEPITER
#define INCLUDED_IDEP_FILEDEPITER

// W tym komponencie zdefiniowano 1 w peni odizolowan klas iteratora:
//    idep_FileDepIter: iteracja pomidzy plikami nagwkowymi wczonymi do pliku programu.
class idep_FileDepIter_i;
class idep_FileDepIter {
    idep_FileDepIter_i *d_this;

  private:
    idep_FileDepIter(const idep_FileDepIter&);            // nie zaimplementowano
    idep_FileDepIter& operator=(const idep_FileDepIter&); // nie zaimplementowano

  public:
    // METODY TWORZCE
    idep_FileDepIter(const char *fileName);
        // Utworzenie iteratora zalenoci fazy kompilacji dla okrelonego pliku.
        // Nazwy plikw wymienionych w dyrektywach preprocesora include zostan         
        // przedstawione w takim porzdku, w jakim znajduj si w analizowanym pliku.
        // Wynik dziaania iteratora obejmuje rwnie zalenoci kompilowane warunkowo lub         // ujte w komentarz wielowierszowy /* ... */.

    ~idep_FileDepIter();

    // METODY OBLICZENIOWE
    void reset();
        // Powrt do pierwszej zalenoci w pliku (jeeli plik zawiera zalenoci).

    void operator++();
        // Przejcie do nastpnej zalenoci w pliku. Dziaanie tej funkcji jest         
        // niezdefiniowane w przypadku, gdy stan iteracji jest niepoprawny. 

    // METODY DOSTPOWE
    int isValidFile() const;
        // Zwraca wartos niezerow, jeeli wymieniony plik jest poprawny/daje si         
        // odczyta. W innym przypadku zwraca 0.

    operator const void *() const;
        // Zwraca warto niezerow, jeeli biecy status iteracji (tzn. zalenoci) jest         // poprawny. W innym przypadku zwraca 0. Naley zwrci uwag, e funkcja ta zwrci         // warto 0, rwnie wtedy, gdy sam plik bdzie niepoprawny.

    const char *operator()() const;
        // Zwraca nazw biecego pliku, od ktrego zaley ten plik.
        // Jeeli status iteracji nie jest poprawny, funkcja zwraca 0.
};

#endif

