// idep_fdepitr.c
#include "idep_filedepiter.h"

#include <ctype.h>      // isspace()
#include <string.h>     // strcspn()
#include <memory.h>     // memcpy()
#include <fstream.h>    // ifstream
#include <assert.h>

                // -*-*-*- funkcje statyczne -*-*-*-

enum { MAX_LINE_LENGTH  = 2048 };       // Dowolna maksymalna dugo wiersza                                          // zawierajcego dyrektyw
                                        // include. Naley zauway, e pozostae wiersze                                        // mog by dusze.

static int loadBuf(istream& in, char *buf, int bufSize)
{
    enum { END_OF_INPUT = -1, SUCCESS = 0, OVERFLOW = 1 };

    // Metoda getline (istream) zwraca wiersz w postaci cigu znakw, ale
    // obcina koczcy znak '\n' tylko wtedy, gdy jest miejsce w buforze.      
    // Warunek ten mona sprawdzi poprzez umieszczenie znaku rnego od znaku null     
    // na ostatniej pozycji tablicy przed jej zaadowaniem. Jeeli po odczytaniu     
    // ostatni znak ma warto null, oznacza to, e znaku koca wiersza nie obcito.

    int nearEnd = bufSize - 1;

    buf[nearEnd] = '\n'; // dowolny znak rny od '\0'

    if (in.getline(buf, bufSize).fail()) {
        return END_OF_INPUT;    // nic nie zostao
    }

    if ('\0' == buf[nearEnd]) { // wiersz by zbyt dugi
        char c;
        while (in && !in.get(c).eof() && c != '\n') {
            // przejcie do nastpnego wiersza
        }
        return OVERFLOW;        // bufor zawiera cig znakw zakoczony znakiem null
    }

    return SUCCESS;
}

const char *extractDependency(char *buffer)
{
    // Zakadamy, e mamy cig znakw zakoczony znakiem nulll,     
    // ktry moe zawiera poprawn dyrektyw include. Zaoymy, e taka dyrektywa     
    // ma nastpujc skadni:
    //
    // ^#[ \t]*"include"[ \t ]*[<"][ \t]*{nazwa_pliku}[>" \t\n]
    //                                   ~~~~~~~~~~
    // tzn.,                             ^interesuje nas to
    //  1. Pierwszym znakiem wiersza musi by '#'
    //  2. Po tym znaku moe wystpowa dowolna liczba spacji lub tabulacji.
    //  3. Nastpnym znakiem rnym od spacji musi by znak 'i', a po nim przyrostek     
    //     "nclude".
    //  4. Po tym cigu znakw moe wystpowac dowolna liczba spacji lub tabulacji.
    //  5. Nastpnym znakiem musi by znak '<' lub '"'. 
    //  6. Po tym znaku moe wystpowa dowolna liczba spacji lub tabulacji.
    //  7. Nastpnie podana jest nazwa pliku zakoczona spacj, znakiem '>' lub '"'.
    //
    // Po znalezieniu dyrektywy include, nastpuje modyfikacja bufora i zwrcenie wskanika     
    // do wczonego pliku. W przeciwnym przypadku funkcja zwraca warto 0. 

    if ('#' != buffer[0]) {                             // 1.
        return 0;
    }

    char *p = buffer;           
    while (isspace(*++p)) {                             // 2.
    }                           

    if ('i' != *p) {                                    // 3a.
        return 0;
    }

    static char KEY[] = "include";
    if (0 != strncmp(p, "include", sizeof KEY - 1)) {   // 3b.
        return 0;
    }
    p += sizeof KEY - 1;        // przemieszczamy si o warto KEY

    while (isspace(*p)) {                               // 4.
        ++p;
    }

    if ('<' != *p && '"' != *p) {                       // 5.
        return 0;
    }
    ++p;

    while (isspace(*p)) {                               // 6.
        ++p;
    }

    // W tym momencie, p wskazuje na pocztek nazwy pliku
    // naley tylko wykry koniec cigu. 

    int length = strcspn(p, " \t\">");
    p[length] = 0;                                      // 7.

    return p;
}

                // -*-*-*- idep_FileDepIter_i -*-*-*-

struct idep_FileDepIter_i {
    ifstream d_file;
    char d_buf[MAX_LINE_LENGTH];
    const char *d_header_p;
    int d_isValidFile;

    idep_FileDepIter_i(const char *fileName);
};

idep_FileDepIter_i::idep_FileDepIter_i(const char *fileName)
: d_file(fileName)
, d_header_p(d_buf)             // jeszcze nie zainicjowano bufora
{
    d_isValidFile = !!d_file;   // zaley od wyniku inicjalizacji
}

                // -*-*-*- idep_FileDepIter -*-*-*-

idep_FileDepIter::idep_FileDepIter(const char *fileName)
: d_this(new idep_FileDepIter_i(fileName))
{
    if (!isValidFile()) {
        d_this->d_header_p = 0; // niepoprawny stan iteracji
    }
    ++*this; // zaadowanie pierwszego wystpienia
}

idep_FileDepIter::~idep_FileDepIter()
{
    delete d_this;
}

void idep_FileDepIter::reset()
{
    if (isValidFile()) {
        d_this->d_file.seekg(ios::beg); // przewinicie do pocztku pliku         
        d_this->d_file.clear(d_this->d_file.rdstate() & ios::badbit);
        d_this->d_header_p = d_this->d_buf;
    }
    ++*this; // zaadowanie pierwszego wystpienia
}

void idep_FileDepIter::operator++()
{
    d_this->d_header_p = 0;
    while (loadBuf(d_this->d_file, d_this->d_buf, sizeof d_this->d_buf) >= 0) {
        if (d_this->d_header_p = extractDependency(d_this->d_buf)) { // `=' ok
            break;
        }
    };
}    

int idep_FileDepIter::isValidFile() const 
{ 
    return d_this->d_isValidFile;
}

idep_FileDepIter::operator const void *() const 
{ 
    return d_this->d_header_p ? this : 0;
}

const char *idep_FileDepIter::operator ()() const 
{ 
    return d_this->d_header_p;
}

