// idep_compiledep.h
#ifndef INCLUDED_IDEP_COMPILEDEP
#define INCLUDED_IDEP_COMPILEDEP

// W tym komponencie - opakowaniu zdefiniowano 3 w peni odizolowane klasy:
//       idep_CompileDep: rodowisko analizy zalenoci fazy kompilacji
//     idep_RootFileIter: iteracja pomidzy okrelonymi zasadniczymi nazwami plikw
//   idep_HeaderFileIter: iteracja pomizy zalenociami kadego pliku

class ostream;
class idep_RootFileIter;
class idep_HeaderFileIter;

class idep_CompileDep_i;
class idep_CompileDep {
    idep_CompileDep_i *d_this;

    friend idep_RootFileIter;
    friend idep_HeaderFileIter;

  private:
    idep_CompileDep(const idep_CompileDep&);            // nie zaimplementowano
    idep_CompileDep& operator=(const idep_CompileDep&); // nie zaimplementowano

  public:
    // METODY TWORZCE
    idep_CompileDep();
    ~idep_CompileDep();

    // METODY OBLICZENIOWE
    void addIncludeDirectory(const char *dirName);
        // Dodanie katalogu, w ktrym bd wyszukiwane pliki include.
        // Podczas procesu oblicze bd wykrywane bdy.

    int readIncludeDirectories(const char *file);
        // Odczytanie listy katalogw include z okrelonego pliku.
        // W tej funkcji zaoono, e kada ciga sekwencja znakw bez spacji
        // reprezentuje katalog, ktry ma by dodany.  Funkcja zwraca warto 0, chyba e               
        // okrelony plik nie daje si odczyta lub zawiera znaki spoza podstawowego
        // kodu ASCII.

    void addRootFile(const char *fileName);
        // Dodaje nazw pliku do analizy. Bdy odczytu tego pliku bd wykryte tylko w                
        // przypadku wywoania operacji calculate().

    int readRootFiles(const char *file);
        // Dodanie listy nazw plikw odczytanych z okrelonego pliku.  
        // W tej funkcji zaoono, e kada ciga sekwencja znakw nie zawierajca spacji
        // reprezentuje nazw pliku, ktr naley doda. Efekt jest taki sam, jakby kad              
        // nazw dodano osobno. Funkcja zwraca warto 0, chyba e okrelony plik         
        // nie daje si odczyta lub zawiera znaki spoza podstawowego kodu ASCII.
        // Bdy odczytu poszczeglnych plikw bd wykryte tylko w przypadku         
        // wywoania operacji przetwarzania.

    void inputRootFiles();
        // Podobne dziaanie do metody readRootFiles poza tym, e dane wejciowe
        // s spodziewane ze standardowego urzdzenia wejciowego, ktre jest zerowane w         
        // przypadku napotkania znaku koca pliku.          
        // Znaki spoza podstawowego kodu ASCII nie s sprawdzane.

    int calculate(ostream& err, int recursionFlag = 1);
        // Oblicza zalenoci fazy kompilacji dla okrelonego zbioru plikw -         
        // korzeni. Zwraca warto 0 w przypadku powodzenia, w przeciwnym przypadku
        // warto rn od zera. Bdy wywietlane s na wskazanym
        // urzdzeniu bdu (err). Domylnie obliczenia zalenoci bd wykonywane         
        // rekurencyjnie nawet dla plikw zdefiniowanych poza biecym katalogiem (jak np.         
        // plikw nagwkowych wskazanych przez kompilator.
        // Podanie 0 jako wartoi opcjonalnego drugiego argumentu powoduje wyczenie         
        // rekurencyjnego poszukiwania zalenoci w plikach zewntrznych.
        // Warto zwrci uwag, e wyczenie rekurencji powoduje znaczne przyspieszenie         
        // dziaania, ale oznacza uwzgldnienie niepenej listy zalenoci fazy         
        // kompilacji.
};

ostream &operator<<(ostream& o, const idep_CompileDep&);
    // wywietlenie zalenoci w formacie standardowym:
    //    cig plikw wywietlanych po jednym w kadym wierszu. Pusty wiersz oznacza koniec        //    kadego cigu. Pierwszy plik w kadym cigu to plik - korze. Kady nastpny     //    plik w cigu reprezentuje plik nagwkowy, od ktrego zaley plik - korze podczas     //    kompilacji.

class idep_RootFileIter_i;
class idep_RootFileIter {
    idep_RootFileIter_i *d_this;

    friend idep_HeaderFileIter;

  private:
    idep_RootFileIter(const idep_RootFileIter&);            // nie zaimplementowano     
    idep_RootFileIter& operator=(const idep_RootFileIter&); // nie zaimplementowano
  public:
    // METODY TWORZCE
    idep_RootFileIter(const idep_CompileDep& compileDep);
    ~idep_RootFileIter();

    // METODY OBLICZENIOWE
    void operator++();

    // METODY DOSTPOWE
    operator const void *() const;
    const char *operator()() const;
        // Zwraca nazw biecego pliku - korzenia.
};

class idep_HeaderFileIter_i;
class idep_HeaderFileIter {
    idep_HeaderFileIter_i *d_this;

  private:
    idep_HeaderFileIter(const idep_HeaderFileIter&);            // nie zaimplementowano
    idep_HeaderFileIter& operator=(const idep_HeaderFileIter&); // nie zaimplementowano

  public:
    // METODY TWORZCE
    idep_HeaderFileIter(const idep_RootFileIter& rootFileIter);
    ~idep_HeaderFileIter();

    // METODY OBLICZENIOWE
    void operator++();

    // METODY DOSTPOWE
    operator const void *() const;
    const char *operator()() const;
        // Zwraca nazw biecego pliku, od ktrego biecy plik - korze zaley podczas               
        // kompilacji (porednio lub bezporednio).
};

#endif


