// idep_aliastable.h
#ifndef INCLUDED_IDEP_ALIASTABLE
#define INCLUDED_IDEP_ALIASTABLE

// W tym komponencie - liciu zdefiniowano 2 klasy:
//       idep_AliasTable: dostarcza odpowiednich (z zastosowaniem mieszania) nazw dla 
//                        odwzorowania
//   idep_AliasTableIter: iteracja w kolekcji odwzorowa nazw
class idep_AliasTableLink;
class idep_AliasTableIter;
class ostream;

class idep_AliasTable {
    idep_AliasTableLink **d_table_p;            // tablica mieszajca
    int d_size;                                 // rozmiar tablicy mieszajcej
    friend class idep_AliasTableIter;

  private:
    idep_AliasTable(const idep_AliasTable&);            // nie zaimplementowana
    idep_AliasTable& operator=(const idep_AliasTable&); // nie zaimplementowana

  public:
    // METODY TWORZCE
    idep_AliasTable(int sizeHint = 0);
        // Utworzenie nowej tabeli; opcjonalnie moliwo podania liczby elementw.
    ~idep_AliasTable();

    // METODY OBLICZENIOWE
    int add(const char *alias, const char *originalName);
        // Dodanie aliasu do tabeli. Zwraca 0 w przypadku powodzenia, 1 jeeli istnieje
        // identyczny alias/nazwa oryginalna, -1 jeeli istnieje alias z inn nazw
        // oryginaln. Funkcja nie powoduje nadpisywania aliasu now nazw oryginaln.
        // (Ani alias, ani nazwa oryginalna nie mog mie wartoci 0.)

    // METODY DOSTPOWE
    const char *lookup(const char *alias) const;
        // Jeeli istnieje alias zwraca nazw oryginaln, w innym przypadku zwraca 0.
};

ostream& operator<<(ostream& output, const idep_AliasTable& table);
    // Zapisuje ca logiczn zawarto wymienionej tabeli aliasw
    // w odpowiednim formacie do wymienionego strumienia wyjciowego.

class idep_AliasTableIter {
    const idep_AliasTable& d_table;     // odwoanie do staej tabeli aliasw    
    idep_AliasTableLink *d_link_p;      // wskanik do biecego cza w tabeli     
    int d_index;                        // indeks biecego elementu

  private:
    idep_AliasTableIter(const idep_AliasTableIter&);            // nie zaimpl.
    idep_AliasTableIter& operator=(const idep_AliasTableIter&); // nie zaimpl.

  public:
    // METODY TWORZCE
    idep_AliasTableIter(const idep_AliasTable& table);
        // Utworzenie iteratora dla okrelonej tabeli.
    ~idep_AliasTableIter();

    // MANIPULATORS
    void reset();
        // Wyzerowanie iteratora, w celu rozpoczcia iteracji.

    void operator++();
        // Przejcie do nastpnej iteracji (pary alias/nazwa oryginalna).

    // METODY DOSTPOWE
    operator const void *() const;
        // Zwraca niezerow warto, jeeli biecy element jest poprawny, w przeciwnym         
        // przypadku zwraca 0.
const char *alias() const;
        // Zwraca biec nazw aliasu.

    const char *originalName() const;
        // Zwraca nazw (oryginaln) odpowiadajc biecemu aliasowi.
};

#endif

 
