// idep_aliasdep.h
#ifndef INCLUDED_IDEP_ALIASDEP
#define INCLUDED_IDEP_ALIASDEP

// W tym komponencie zdefiniowano 1 w peni odizolowan klas - opakowanie:
//   idep_AliasDep: rodowisko tworzenia/weryfikowania aliasw nazw plikw
class ostream;
class istream;

class idep_AliasDep_i;
class idep_AliasDep {
    idep_AliasDep_i *d_this;

  private:
    idep_AliasDep(const idep_AliasDep&);                // nie zaimplementowano
    idep_AliasDep& operator=(const idep_AliasDep&);     // nie zaimplementowano

  public:
    // METODY TWORZCE
    idep_AliasDep();
    ~idep_AliasDep();

    // METODY OBLICZENIOWE
    void addIgnoreName(const char *name);
        // Dodanie nazwy, ktra  ma by pominita podczas przetwarzania. Argument wiersza polecenia
        // lub pozycja w pliku -f<lista_plikw> odpowiadajca podanej nazwie nie bdzie uwzgldniana
        // podczas analizy.

    int readIgnoreNames(const char *file);
        // Dodanie listy nazw, ktre maj by zignorowane podczas przetwarzania.          
        // W tej funkcji zaoono, e kada ciga sekwencja znakw nie zawierajca spacji
        // reprezentuje nazw, ktr naley zignorowa. Funkcja zwraca warto 0, chyba e         
        // okrelony plik nie daje si odczyta lub zawiera znaki spoza podstawowego         
        // kodu ASCII.

    const char *addAlias(const char *aliasName, const char *componentName);
        // Dodanie pary nazw alias/komponent do zbioru aliasw.         
        // Funkcja zwraca 0 w przypadku sukcesu lub cig znakw zawierajcy
        // odpowiadajc poprzednio nazw komponentu dla tego aliasu, ktra
        // nie jest identyczna do nazwy podanej jako argument tej funkcji.

    int readAliases(ostream& err, const char *file);
        // Odczytanie listy aliasw komponentw z okrelonego pliku. Kada
        // ciga sekwencja znakw nie zawierajca spacji reprezentuje nazw.
        // Nazwy s rwnie uoone w sekwencje. Pierwsza nazwa w sekwencji nazw
        // reprezentuje waciw nazw komponent.  
        // Nazwy w tym samym wierszu (sekwencja pozioma) lub w kolejnych wierszach
        // (sekwencja pionowa) s interpretowane jako aliasy tej nazwy komponentu.
        // Sekwencja pozioma koczy si znakiem koca wiersza ('\n')
        // o ile nie jest poprzedzona znakiem odwrotnego ukonika ('\\'). Sekwencja pionowa         
        // koczy si pustym wierszem. W przypadku powodzenia funkcja zwraca 0 bez wywietlania         
        // adnych komunikatw. Jeeli wymieniony plik nie daje si odczyta, funkcja
        // zwraca -1 (bez komunikatw). W przypadku napotkania aliasu, ktry jest niespjny
        // z aliasem wymienionym poprzednio, jest on wywietlany na standardowym         
        // urzdzeniu bdu. Po zakoczeniu analizy, funkcja zwraca liczb niezgodnych         
        // aliasw.

    void addFileName(const char *fileName);
        // Dodanie pliku do analizy. Bdy odczytu tego pliku bd wykryte tylko w         
        // przypadku wywoania operacji przetwarzania.

    int readFileNames(const char *file);
        // Dodanie listy nazw plikw odczytanych z okrelonego pliku. 
        // W tej funkcji zaoono, e kada ciga sekwencja znakw nie zawierajca spacji
        // reprezentuje nazw pliku, ktr naley doda. Efekt jest taki sam, jakby kad         
        // nazw dodano osobno. Funkcja zwraca warto 0, chyba e okrelony plik         
        // nie daje si odczyta lub zawiera znaki spoza podstawowego kodu ASCII.
        // Bdy odczytu poszczeglnych plikw bd wykryte tylko w przypadku         
        // wywoania operacji przetwarzania.

    void inputFileNames();
        // Podobne dziaanie do metody readFileNames poza tym, e dane wejciowe pochodz 
        // ze standardowego urzadzenia wejciowego, ktre jest zerowane w przypadku
        // napotkania znaku koca pliku. Znaki spoza podstawowego kodu ASCII nie bed
        // sprawdzane.

    // METODY DOSTPOWE
    int unpaired(ostream& out, ostream& err, int suffixFlag = 1) const;
        // Wywietla list plikw, ktrych nie udao si poczy w pary na
        // posta standardowego strumienia wyjciowego. Wywietlenie ostrzeenia na         
        // standardowym urzdzeniu bdu w przypadku napotkania dwch plikw
        // o tej samej nazwie zasadniczej. Domylnie, podczas identyfikowania plikw nie         
        // poczonych w pary uwzgldnia si rozszerzenia. Ustawienie flagi suffixFlag na 0         
        // powoduje, e wywietlane bd tylko nazwy zasadnicze, w porzdku uatwiajcym 
        // tworzenie pliku aliasw za pomoc operacji wytnij i wklej w edytorze.
        // Funkcja zwraca liczb plikw, ktrych nie dao si poczy w pary.

    int verify(ostream& err) const;
        // Sprawdzenie, czy wszystkie wymienione zalenoci plikw .c        
        // prawidowo poczono w pary po zastosowaniu aliasw. W przypadku, gdy plik         
        // nagwkowy odpowiadajcy wymienionemu plikowi .c nie zosta wymieniony w pierwszej         
        // dyrektywie #include w tym pliku, zostanie zgoszony bd na okrelonym urzdzeniu         
        // bdu.          
        // Jeeli nie mona odczyta ktregokolwiek z wymienionych plikw, metoda zwraca         
        // warto ujemn. W innym przypadku zwraca liczb plikw, w ktrych brakuje dyrektyw 
        // include lub, w ktrych dyrektywy te umieszczono na niewaciwej pozycji. 

    int extract(ostream& out, ostream& err) const;
        // Okrela potrzebne aliasy dla wymienionego zbioru plikw (.c)
        // i formatuje je dla okrelonego strumienia wyjciowego zakadajc, e
        // w danym pliku .c odpowiadajcy mu plik nagwkowy wymieniono w pierwszej
        // dyrektywie include. W przypadku, gdy plik (.c) nie zawiera dyrektyw include        
        // zostanie zgoszony bd na okrelonym urzdzeniu bdu. Jeeli ten sam plik         
        // nagwkowy przydzielono do wicej ni jednego pliku .c, na urzdzeniu bdu         
        // zostanie wywietlone ostrzeenie.
        // Jeeli nie mona odczyta ktregokolwiek z wymienionych plikw, metoda zwraca               
        // warto ujemn. W innym przypadku metoda zwraca liczb plikw, ktre nie         
        // zawieraj dyrektyw include.
};

#endif


