// idep_nameindexmap.h
#ifndef INCLUDED_IDEP_NAMEINDEXMAP
#define INCLUDED_IDEP_NAMEINDEXMAP

// W tym komponencie zdefiniowano 1 w peni odizolowan klas:
//   idep_NameIndexMap: wydajne dwukierunkowe odwzorowania pomidzy indeksami, a cigami znakw
class ostream;

class idep_NameIndexMap_i;
class idep_NameIndexMap {
    idep_NameIndexMap_i *d_this;

  private:
    idep_NameIndexMap(const idep_NameIndexMap&);            // nie zaimplementowano
    idep_NameIndexMap& operator=(const idep_NameIndexMap&); // nie zaimplementowano
  public:
    // METODY TWORZCE
    idep_NameIndexMap(int maxEntriesHint = 0);
        // Utworzenie nowego odwzorowania; opcjonalnie podanie spodziewanej liczby pozycji.
        // Domylnie utworzona bdzie umiarkowanie dua tablica mieszajca.
    ~idep_NameIndexMap();

    // METODY OBLICZENIOWE
    int add(const char* name);
        // Dodanie nazwy do odwzorowania i zwrcenie indeksu tylko wtedy, gdy odwzorownie         
        // jeszcze tej nazwy nie zawiera. W innym przypadku zwrcenie wartoci -1.

    int entry(const char* name);
        // Dodanie nazwy do tabeli, jeeli zachodzi taka potrzeba. Metoda zawsze zwraca poprawny indeks.
        // Uwaga: metoda entry() jest zazwyczaj bardziej wydajna od metody lookup(), po  ktrej wywoano metod add().

    // METODY DOSTPOWE
    const char *operator[](int) const;
        // Zwraca nazw skojarzon z podanym indeksem lub 0, jeeli podano indeks 
        // spoza zakresu [0 .. N], gdzie N = rozmiar - 1.

    int length() const;
        // Zwraca liczb niepowtarzalnych nazw w tym odwzorowaniu.

    int lookup(const char *name) const;
        // Zwraca indeks okrelonej nazwy lub -1, jeeli nazwy nie znaleziono.
};

ostream& operator<<(ostream& out, const idep_NameIndexMap& map);
        // Wywietla logiczn zawarto biecego odwzorowania na podanym strumieniu         
        // wyjciowym w odpowiednim formacie.
        
#endif

