// idep_binrel.h
#ifndef INCLUDED_IDEP_BINREL
#define INCLUDED_IDEP_BINREL

// W tym komponencie - liciu zdefiniowano 1 klas:
//   idep_BinRel: kwadratowa macierz bitw posiadajca waciwo przechodniego zakaczania.
class ostream;

class idep_BinRel {
    char **d_rel_p;     // tablica wskanikw do cigej tablicy bajtw
    int d_size;         // fizyczny rozmiar tablicy
    int d_length;       // logiczny rozmiar tablicy

  private:
    void grow();
      // Zwikszenie fizycznego rozmiaru tej relacji.

    void compress();
      // Przypisanie logicznego rozmiaru rozmiarowi fizycznemu (o ile nie wynosi 0).

    void warshall(int bit);
      // Wykonanie algorytmu Warshalla w przd lub w ty. 

  public:
    // METODY TWORZCE
    idep_BinRel(int initialEntries = 0, int maxEntriesHint = 0);
        // Utworzenie binarnej relacji, ktr mona rozszerza w miar potrzeb.
        // Domylnie, pocztkowa liczba pozycji w relacji wynosi 0.
        // Jeeli znana jest ostateczna liczba zapisw i jest ona rna         
        // od wartoci argumentu initialEntries, to warto t mona opcjonalnie         
        // poda jako drugi argument (jako "wskazwk").

    idep_BinRel(const idep_BinRel& rel);
    ~idep_BinRel();

    // METODY OBLICZENIOWE
    idep_BinRel& operator=(const idep_BinRel& rel);

    void set(int row, int col, int bit);
        // Ustawienie liczby wierszy/kolumn w tej relacji         
        // na okrelon warto binarn.

    void set(int row, int col);
        // Ustawienie liczby wierszy/kolumn w tej relacji na 1.

    void clr(int row, int col);
        // Ustawienie liczby wierszy/kolumn w tej reacji na 0.
    void makeTransitive();
        // Zastosowanie do tej relacji algorytmu Warshalla. W wyniku otrzymamy zwrotne         
        // przechodnie zakoczenie pierwotnej relacji.

    void makeNonTransitive();
        // Usunicie wszystkich redundantnych relacji tak, aby
        // nie narusza przechodniego zakaczania. W przypadku wystpowania        
        // cyklicznej zalenoci rozwizanie nie jest jednoznaczne. Aby funkcja dziaaa
        // poprawnie, relacja musi by w peni przechodnia
        // (patrz makeTransitive).

    int appendEntry();
        // Dodanie pozycji do biecej relacji i zwrcenie jej indeksu.
        // Dla wszystkich wyzerowanych pozycji, logiczny rozmiar jest zwikszany o 1.

    // METODY DOSTPOWE
    int get(int row, int col) const;
        // Uzyskanie logicznej wartoci dla okrelonego wiersza/kolumny biecej relacji.

    int cmp(const idep_BinRel& rel) const;
        // Zwraca 0, wtedy i tylko wtedy, gdy wymieniona relacja ma t sam dugo
        // i wartoci logiczne co relacja bieca.

    int length() const;
        // Zwraca liczb wierszy i kolumn w biecej relacji. Dugo
        // reprezentuje liczno zbioru, dla ktrego zdefiniowano relacj.
};

ostream& operator<<(ostream& out, const idep_BinRel& rel);
   // Wyprowadzenie tej relacji binarnej na standardowym strumieniu wyjciowym w    
   // formacie wiersz/kolumna (pierwszym elementem jest lewy, grny rg).

int operator==(const idep_BinRel& left, const idep_BinRel& right);
   // Zwraca 1, jeeli dwie relacje s sobie rwne i 0 w przeciwnym przypadku (zobacz cmp).

int operator!=(const idep_BinRel& left, const idep_BinRel& right);
   // Zwraca warto 1, jeeli dwie relacje nie s rwne i 0 w przeciwnym przypadku (patrz cmp).

// #########################################################################
// Poniej znajduj si definicje funkcji wstawianych tego komponentu.
// #########################################################################

inline
int idep_BinRel::appendEntry() 
{
    if (d_length >= d_size) {
        grow();
    }
    return d_length++;
}

inline
void idep_BinRel::set(int row, int col, int bit) 
{
    d_rel_p[row][col] = !!bit;
}

inline
void idep_BinRel::set(int row, int col) 
{
    d_rel_p[row][col] = 1;
}

inline
void idep_BinRel::clr(int row, int col) 
{
    d_rel_p[row][col] = 0;
}

inline
int idep_BinRel::get(int row, int col) const
{
    return d_rel_p[row][col];
}

inline
int idep_BinRel::length() const
{
    return d_length;
}

inline
int operator==(const idep_BinRel& left, const idep_BinRel& right) 
{
    return left.cmp(right) == 0;
}

inline
int operator!=(const idep_BinRel& left, const idep_BinRel& right) 
{
    return left.cmp(right) != 0;
}

#endif

