// idep_aliasutil.h
#ifndef INCLUDED_IDEP_ALIASUTIL
#define INCLUDED_IDEP_ALIASUTIL

// W tym komponencie zdefiniowano 1 proceduraln klas narzdziow:
//   idep_AliasUtil: aduje tabel aliasw na podstawie informacji odczytywanych z pliku
class idep_AliasTable;
class ostream;
class istream;

struct idep_AliasUtil {
    static int readAliases(idep_AliasTable *table, ostream& err, istream& in,
                                                       const char *inputName);
    static int readAliases(idep_AliasTable *table, ostream& err,
                                                       const char *fileName);
        // Odczytuje opis aliasw z okrelonego strumienia lub pliku
        // i aduje te informacje do wymienionej tabeli aliasw.
        // Ciga sekwencja znakw nie zawierajca spacji jest interpretowana jako nazwa.
        // Pierwsza nazwa w wierszu reprezentuje nazw "na", reszta reprezentuje
        // nazwy "z". Jeeli w pierwszym werszu definicji znajduje si pojedyncza nazwa,         
        // oznacza to przejcie do nastpnej pozycji na licie (za pustym wierszem).
        // Cigi znakw rozpoczynajce si od znaku '#' s ignorowane, a do koca biecego         
        // wiersza.
        //
        //   # to tylko komentarz
        //   a b c #d e f               # b -> a; c -> a
        //   d e                        # e -> d
        //   f
        //   g h                        # g -> f; h -> f
        //   i                          # i -> f
        //
        //   j k                        # k -> j
        //
        // Wiersz mona kontynuowa, jeeli znak koca wiersza ('\n') poprzedzi si
        // wystpujcym osobno znakiem odwrotnego ukonika ('\\'). Warto zwrci uwag, e ani
        // cig "a\", ani "\# komentarz" nie s traktowane jako kontynuacja
        // wiersza.
        //
        //   l \ # wiersz bdzie kontynuowany
        //   m n                        # m -> l; n -> l
        //
        //   o
        //   p q                        # p -> o; q -> o
        //   \ # po prostu komentarz \
        //   r                          # r -> o
        //
        //   s t \                      # t -> s
        //
        //   u v                        # v -> u
        //
        // Znak odwrotnego ukonika, po ktrym nie nastpuje znak koca wiersza
        // jest interpretowany jako identyfikator. W takiej sytuacji wywietlone zostanie        
        // ostrzeenie.
        //
        //   \ w                        # w -> \        (ostrzeenie)
        //   x \ \                      # \ -> x        (ostrzeenie)
        //   y\                         # y\ -> x
        //   z z \#oops                 # z -> z; \#oops -> z
        //
        // Funkcja read-from-file zwraca -1 w przypadku, gdy plik nie daje si
        // odczyta.
        // W innym przypadku obie funkcje zwracaj nieujemn liczb aliasw niespjnych         
        // z istniejcymi definicjami aliasw. Wszystkie bdy tego typu s take jawnie
        // zgaszane na okrelonym strumieniu bdw (err).
};

#endif
