// cdep.c
#include "idep_compiledep.h"
#include <iostream.h>

// Ten plik zawiera gwny program wykorzystujcy komponent idep_compiledep.

#define NL "\n"
static const char *help()
{
return NL
"cdep: okrela zalenoci fazy kompilacji na podstawie zbioru plikw."                     NL
""                                                                                         NL
"  Poniszy wiersz przedstawia skadni wiersza polecenia"                                 NL
""                                                                                         NL
"    cdep [-I<katalog>] [-i<lista_katalogw>] [-f<lista_plikw>] [-x] <nazwa_pliku>*"      NL
""                                                                                         NL
"      -I<katalog>          Katalog include do przeszukiwania."                            NL
"      -i<lista_latalogw>  Okrelenie listy katalogw do przeszukiwania."                 NL
"      -f<lista_plikw>     Okrelenie pliku zawierajcego list plikw do przetwarzania." NL
"      -x                   Wyczenie rekurencyjnego przeszukiwania zagniedzonych"       NL
"                           dyrektyw include."                                             NL
""                                                                                         NL
"    Kada nazwa pliku w wierszu polecenia definiuje plik, ktry naley uwzgldni"        NL
"    podczas przetwarzania. W przypadku braku argumentw lista plikw bdzie pobrana"      NL
"    ze standardowego urzdzenia wejciowego, o ile nie uyto opcji -f."                   NL
""                                                                                         NL
"  TYPOWE ZASTOSOWANIA:"                                                                   NL
""                                                                                         NL
"    cdep -iincludes *.[ch]"                                                               NL
NL;
}

static enum { IOERROR = -1, GOOD = 0 } s_status = GOOD;

static ostream& err()
{
    s_status = IOERROR;
    return cerr << "Bd: ";
}

static int missing(const char *argName, char option)
{
/*
    err() << "brakujcy " << argName << " argument dla opcji -"
	  << option << "." << endl;
    return s_status; */
}

static int extra(const char *text, char option)
{
    err() << "wykryto dodatkowy tekst \"" << text << "\" za opcj -"
          << option << "." << endl;
    return s_status;
}

static int unreadable(const char *dirFile, char option)
{
    err() << "nie mona odczyta \"" << dirFile << "\" dla opcji -"
          << option << "." << endl;
    return s_status;
}

static const char *getArg(int *i, int argc, const char *argv[])
{
    return 0 != argv[*i][2] ? argv[*i] + 2 :
           ++*i >= argc || '-' == argv[*i][0] ? "" : argv[*i];
}

int main (int argc, const char *argv[])
{
    int argCount = 0;        // liczba plikw w wierszu polecenia
    int fileFlag = 0;        // -f<plik> ustawia t warto na 1
    int recursionFlag = 1;   // -x ustawia t warto na 0
    idep_CompileDep environment;
    for (int i = 1; i < argc; ++i) {
        const char *word = argv[i];
        if  ('-' == word[0]) {
            char option = word[1];
            switch(option) {
              case 'I': {
                const char *arg = getArg(&i, argc, argv);
                if (!*arg) {
                    return missing("katalog", option);
                }
                environment.addIncludeDirectory(arg);
              } break;
              case 'i': {
                const char *arg = getArg(&i, argc, argv);
                if (!*arg) {
                    return missing("plik", option);
                }
                if (0 != environment.readIncludeDirectories(arg)) {
                    return unreadable(arg, option);
                }
              } break;
              case 'f': {
                const char *arg = getArg(&i, argc, argv);
                if (!*arg) {
                    return missing("plik", option);
                }
                if (0 != environment.readRootFiles(arg)) {
                    return unreadable(arg, option);
                }
                fileFlag = 1;
              } break;
              case 'x': {
                const char *arg = getArg(&i, argc, argv);
                if (*arg) {
                    return extra(arg, option);
                }
                recursionFlag = 0;
              } break;
              default: {
                 err() << "nieznana opcja \"" << word << "\"." << endl
                       << help();
                 return s_status;
              } break;
            }
        }
        else {
            ++argCount;
            environment.addRootFile(argv[i]);
        }
    }

    if (!fileFlag && !argCount) {
        environment.inputRootFiles();
    }

    if (environment.calculate(cerr, recursionFlag)) {
         s_status = IOERROR;
    }

    cout << environment;

    return s_status;
}

