// adep.c
#include "idep_aliasdep.h"
#include <iostream.h>

// Ten plik zawiera gwny program wykorzystujcy komponent idep_aliasdep.
#define NL "\n"
static const char *help()
{
return NL
"adep - tworzy aliasy grup plikw do postaci spjnych komponentw."                      NL
""                                                                                       NL
"  Istniej 3 tryby interfejsu wiersza polecenia:"                                       NL
""                                                                                       NL
"    adep [-s] [-a<alias>] [-f<lista_plikw> ] [-X<fn>] [-x<Plikx>] <nazwa_pliku>*"      NL
"    adep -v [-a<alias>] [-f<lista_plikw>] [-X<fn>] [-x<Plikx>] <nazwa_pliku_c>*"       NL
"    adep -e [-a<alias>] [-f<lista_plikw>] [-X<fn>] [-x<Plikx>] <nazwa_pliku_c>*"       NL
""                                                                                       NL
"   -s             Wycza wywietlanie rozszerze nazw nie poczonych w pary."         NL
"   -v             Sprawdza, czy plik zawiera nazw komponentu jako pierwsz zaleno." NL
"   -e             Okrelenie aliasw na podstawie nazwy pierwszej zalenoci."          NL
"   -a<alias>      Okrelenie pliku zawierajcego aliasy nazw komponentw."              NL
"   -f<nazwa_pliku>Okrelenie pliku zawierajcego list pliku do analizy."               NL
"   -X<fn>         Okrelenie nazwy pliku do zignorowania podczas przetwarzania."        NL
"   -x<Plikx>      Okrelenie pliku zawierajcego list plikw do zignorowania."         NL
""                                                                                       NL
"    Kada nazwa pliku w wierszu polecenia definiuje plik, ktry naley uwzgldni"      NL
"    podczas przetwarzania.  W przypadku braku argumentw lista plikw bdzie pobrana"   NL
"    ze standardowego urzdzenia wejciowego,o ile nie uyto opcji -f."                  NL
""                                                                                       NL
"  TYPOWE ZASTOSOWANIA:"                                                                 NL
""                                                                                       NL
"    adep -s *.[ch]                     // wywietlenie na urzdzaniu stdout plikw,"    NL
"                                       // ktrych nie mona poczy w pary"            NL
""                                                                                       NL
"    adep -v -aaliases *.c              // wywietlenie bdw dyrektyw #include na "    NL
"                                       // urzdzeniu stderr"                            NL
""                                                                                       NL
"    adep -e *.c                        // wywietlenie pobranych aliasw na "           NL
"                                       // urzdzeniu stderr"NL
NL;
}

static enum { IOERROR = -1, GOOD = 0, BAD = 1 } s_status = GOOD;

static ostream& err()
{
    s_status = IOERROR;
    return cerr << "Bd: ";
}

static int missing(const char *argName, char option)
{
    err() << "brakujcy argument`" << argName << "' dla opcji -"
          << option << "." << endl;
    return s_status;
}

static int extra(const char *text, char option)
{
    err() << "wykryto dodatkowy tekst \"" << text << "\" za opcj -"
          << option << "." << endl;
    return s_status;
}

static int unreadable(const char *dirFile, char option)
{
    err() << "nie mona odczyta \"" << dirFile << "\" dla opcji -"
          << option << "." << endl;
    return s_status;
}

static int incorrect(const char *file, char option)
{
    err() << "plik \"" << file << "\" zawiera nieprawidow zawarto dla opcji -"
          << option << "." << endl;
    return s_status;
}

static const char *getArg(int *i, int argc, const char *argv[])
{
    return 0 != argv[*i][2] ? argv[*i] + 2 :
           ++*i >= argc || '-' == argv[*i][0] ? "" : argv[*i];
}

int main (int argc, const char *argv[])
{
    int argCount = 0;        // liczba plikw w wierszu polecenia
    int fileFlag = 0;        // -f<plik> ustawia t warto na 1
    int suffixFlag = 1;      // -s ustawia t warto na 0
    int verifyFlag = 0;      // -v ustawia warto na 1
    int extractFlag = 0;     // -e ustawia t warto na 1

    idep_AliasDep environment;
    for (int i = 1; i < argc; ++i) {
        const char *word = argv[i];
        if  ('-' == word[0]) {
            char option = word[1];
            switch(option) {
              case 'X': {
                const char *arg = getArg(&i, argc, argv);
                if (!*arg) {
                    return missing("dir", option);
                }
                environment.addIgnoreName(arg);
              } break;
              case 'x': {
                const char *arg = getArg(&i, argc, argv);
                if (!*arg) {
                    return missing("plik", option);
                }
                if (0 != environment.readIgnoreNames(arg)) {
                    return unreadable(arg, option);
                }
              } break;
              case 'a': {
                const char *arg = getArg(&i, argc, argv);
                if (!*arg) {
                    return missing("plik", option);
                }
                int s = environment.readAliases(cerr, arg);
                if (s < 0) {
                    return unreadable(arg, option);
                }
                if (s > 0) {
                    return incorrect(arg, option);
                }
              } break;
              case 'f': {
                const char *arg = getArg(&i, argc, argv);
                if (!*arg) {
                    return missing("plik", option);
                }
                if (0 != environment.readFileNames(arg)) {
                    return unreadable(arg, option);
                }
                fileFlag = 1;
              } break;
              case 's': {
                const char *arg = word + 2;
                if (*arg) {
                    return extra(arg, option);
                }
                suffixFlag = 0;
              } break;
              case 'v': {
                const char *arg = word + 2;
                if (*arg) {
                    return extra(arg, option);
                }
                verifyFlag = 1;
              } break;
              case 'e': {
                const char *arg = word + 2;
                if (*arg) {
                    return extra(arg, option);
                }
                extractFlag = 1;
              } break;
              default: {
                 err() << "nieznana opcja \"" << word << "\"." << endl
                       << help();
                 return s_status;
              } break;
            }
        }
        else {
            ++argCount;
            environment.addFileName(argv[i]);
        }
    }

    if (!fileFlag && !argCount) {
        environment.inputFileNames();
    }

    int result = extractFlag ? environment.extract(cout, cerr) 
                             : verifyFlag  
                             ? environment.verify(cerr) 
                             : environment.unpaired(cout, cerr, suffixFlag);

    s_status = result < 0 ? IOERROR : result > 0 ? BAD : GOOD;

    return s_status;
}

