/********************************************************
 * Database --  Bardzo prosty program bazodanowy        *
 *              wyszukujacy imie na wbudowanej liscie. *
 *                                                      *
 * Zastosowanie:                                        *
 *      database [-S<plik>]                             *
 *                                                      *
 *      -S<plik>        okresla plik rejestru           *
 *                      do operacji wykrywania bledow   *
 *                                                      *
 *             Program poprosi o podanie imienia.       *
 *             Po jego wprowadzeniu program poinformuje *
 *             czy znajduje sie ono na liscie.          *
 *                                                      *
 * Nie podanie imienia powoduje zamkniecie programu.    *
 ********************************************************/
#include <stdio.h>
#include <stdlib.h>

FILE *save_file = NULL; /* definicja pliku rejestru, jesli jest wymagany */
char *extended_fgets(char *, int, FILE *);

int main(int argc, char *argv[])
{
    char name[80];      /* szukane imie */
    char *save_file_name; /* nazwa pliku rejestru */

    int lookup(char const *const name); /* szukane imie */

    while ((argc > 1) && (argv[1][0] == '-')) {
        switch (argv[1][1]) {
	    /* -S<plik>  okresla plik rejestru */
            case 'S':
                save_file_name = &argv[1][2];
                save_file = fopen(save_file_name, "w");
                if (save_file == NULL) 
                    fprintf(stderr,
                      "Ostrzezenie:Nie mozna otworzyc pliku rejestru %s\n",
                        save_file_name);
                break;
            default:
                fprintf(stderr,"Nieprawidlowa opcja: %s\n", argv[1]);
                exit (8);
        }
        --argc;
        ++argv;
    }    


    while (1) {
        printf("Podaj imie: ");
        extended_fgets(name, sizeof(name), stdin);

        /* ... Reszta programu ... */
    }
}
