// Projekt: Binary_Search_Tree.cbp
// Plik   : BSTNode.cpp

#include "BSTNode.h"

BST::BST() : root(NULL)
{
}

BSTNode * BST::Insert(BSTNode * node, int key)
{
    // Jeli BST nie istnieje, tworzy nowy wze jako korze.
    // Jeli wze nie ma dziecka, mona w takim miejscu wstawi nowy wze.
    if(node == NULL)
    {
        node = new BSTNode;
        node->Key = key;
        node->Left = NULL;
        node->Right = NULL;
        node->Parent = NULL;
    }
    // Jeli warto wskazanego klucza jest wiksza od wartoci klucza wza, przechodzimy do prawego poddrzewa.
    else if(node->Key < key)
    {
        node->Right = Insert(node->Right, key);
        node->Right->Parent = node;
    }
    // Jeli warto wskazanego klucza jest mniejsza od wartoci klucza wza, przechodzimy do lewego poddrzewa.
    else
    {
        node->Left = Insert(node->Left, key);
        node->Left->Parent = node;
    }

    return node;
}

void BST::Insert(int key)
{
    // Wywouje funkcj Insert(), ktrej przekazuje wze korzenia i klucz.
    root = Insert(root, key);
}

void BST::PrintTreeInOrder(BSTNode * node)
{
    // Przestaje wywietla wyniki, jeli nie znajduje wza.
    if(node == NULL)
        return;

    // Pobiera najpierw klucz o najmniejszej wartoci, ktry znajduje si w lewym poddrzewie.
    PrintTreeInOrder(node->Left);

    // Wywietla klucz.
    std::cout << node->Key << " ";

    // Przechodzi do klucza o najwikszej wartoci, ktry znajduje si w prawym poddrzewie.
    PrintTreeInOrder(node->Right);
}

void BST::PrintTreeInOrder()
{
    // Przechodzi po BST, zaczynajc od wza korzenia, i wywietla wszystkie klucze.
    PrintTreeInOrder(root);
    std::cout << std::endl;
}

BSTNode * BST::Search(BSTNode * node, int key)
{
    // Nie znaleziono wskazanego klucza w BST.
    if (node == NULL)
        return NULL;
    // Znaleziono wskazany klucz.
    else if(node->Key == key)
        return node;
    // Podany klucz ma wiksz warto od klucza biecego wza.
    else if(node->Key < key)
        return Search(node->Right, key);
    // Podany klucz ma mniejsz warto od klucza biecego wza.
    else
        return Search(node->Left, key);
}

bool BST::Search(int key)
{
    // Wywouje operacj Search() i przekazuje jej wze korzenia.
    BSTNode * result = Search(root, key);

    // Jeli znaleziono klucz, zwraca true; w przeciwnym przypadku zwraca false.
    return result == NULL ?
        false :
        true;
}

int BST::FindMin(BSTNode * node)
{
    if(node == NULL)
        return -1;
    else if(node->Left == NULL)
        return node->Key;
    else
        return FindMin(node->Left);
}

int BST::FindMin()
{
    return FindMin(root);
}

int BST::FindMax(BSTNode * node)
{
    if(node == NULL)
        return -1;
    else if(node->Right == NULL)
        return node->Key;
    else
        return FindMax(node->Right);
}

int BST::FindMax()
{
    return FindMax(root);
}

int BST::Successor(BSTNode * node)
{
    // Nastpnik ma najmniejsz warto klucza w prawym poddrzewie.
    if (node->Right != NULL)
    {
        return FindMin(node->Right);
    }
    // Jeli nie ma poddrzewa po prawej:
    else
    {
        BSTNode * parentNode = node->Parent;
        BSTNode * currentNode = node;

        // Jeli currentNode nie jest korzeniem, a jest prawym dzieckiem, przechodzi wyej.
        while ((parentNode != NULL) &&
            (currentNode == parentNode->Right))
        {
            currentNode = parentNode;
            parentNode = currentNode->Parent;
        }

        // Jeli parentNode nie jest NULL, to klucz parentNode jest nastpnikiem wza.
        return parentNode == NULL ?
            -1 :
            parentNode->Key;
    }
}

int BST::Successor(int key)
{
    // Szuka najpierw wza klucza.
    BSTNode * keyNode = Search(root, key);

    // Zwraca klucz. Jeli klucz nie zosta znaleziony lub nie znaleziono jego nastpnika, zwraca -1.
    return keyNode == NULL ?
        -1 :
        Successor(keyNode);
}

int BST::Predecessor(BSTNode * node)
{
    // Poprzednik ma najwiksz warto klucza w lewym poddrzewie.
    if (node->Left != NULL)
    {
        return FindMax(node->Left);
    }
    // Jeli nie ma poddrzewa po lewej:
    else
    {
        BSTNode * parentNode = node->Parent;
        BSTNode * currentNode = node;

        // Jeli currentNode nie jest korzeniem, a jest lewym dzieckiem, przechodzi wyej.
        while ((parentNode != NULL) &&
            (currentNode == parentNode->Left))
        {
            currentNode = parentNode;
            parentNode = currentNode->Parent;
        }

        // Jeli parentNode nie jest NULL, to klucz parentNode jest poprzednikiem wza.
        return parentNode == NULL ?
            -1 :
            parentNode->Key;
    }
}

int BST::Predecessor(int key)
{
    // Szuka najpierw wza klucza.
    BSTNode * keyNode = Search(root, key);

    // Zwraca klucz. Jeli klucz nie zosta znaleziony lub nie znaleziono jego poprzednika, zwraca -1.
    return keyNode == NULL ?
        -1 :
        Predecessor(keyNode);
}

BSTNode * BST::Remove(
    BSTNode * node,
    int key)
{
    // Wskazany wze nie zosta znaleziony w BST.
    if (node == NULL)
        return NULL;

    // Znaleziono wskazany wze.
    if (node->Key == key)
    {
        // Jeli wze jest liciem, mona go bezpiecznie usun.
        if (node->Left == NULL && node->Right == NULL)
            node = NULL;
        // Jeli wze ma tylko jedno dziecko po prawej:
        else if (node->Left == NULL && node->Right != NULL)
        {
            // Jedyne dziecko zostaje bezporednio podczone do rodzica swojego rodzica.
            node->Right->Parent = node->Parent;

            // Pomija wze.
            node = node->Right;
        }
        // Jeli wze ma tylko jedno dziecko po lewej:
        else if (node->Left != NULL && node->Right == NULL)
        {
            // Jedyne dziecko zostaje bezporednio podczone do rodzica swojego rodzica.
            node->Left->Parent = node->Parent;

            // Pomija wze.
            node = node->Left;
        }
        // Jeli wze ma dwoje dzieci (lewe i prawe):
        else
        {
            // Wyszukuje nastpnik i poprzednik, aby unikn bdu.
            int successorKey = Successor(key);

            // Zastpuje klucz wza kluczem nastpnika.
            node->Key = successorKey;

            // Usuwa klucz starego nastpnika.
            node->Right = Remove(node->Right, successorKey);
        }
    }
    // Jeli warto klucza docelowego wza jest mniejsza od wartoci podanego klucza, szukanie odbywa si w prawo:
    else if (node->Key < key)
        node->Right = Remove(node->Right, key);
    // Jeli warto klucza docelowego wza jest wiksza od wartoci podanego klucza, szukanie odbywa si w lewo:
    else
        node->Left = Remove(node->Left, key);

    // Zwraca zaktualizowane BST.
    return node;
}

void BST::Remove(int key)
{
    root = Remove(root, key);
}



