// Projekt: Palindrome.cbp
// Plik   : Palindrome.cpp

#include <iostream>
#include <algorithm>

using namespace std;

bool IsPalindrome(
   string str)
{
   // Wielko znakw nie ma znaczenia,
   // wic przeksztacamy wszystkie litery
   // w wielkie.
   transform(
      str.begin(),
      str.end(),
      str.begin(),
      ::toupper);

   // Spacje nie s istotne,
   // wic usuwamy je, jeli s obecne.
   str.erase(
      remove(
         str.begin(),
         str.end(),
         ' '),
         str.end());

   // --- Wykrywacz palindromw ---
   // Zaczyna od elementw znajdujcych si
   // na prawym i lewym kracu str.
   int left = 0;
   int right = str.length() - 1;

   // Porwnuje elementy, ktre obecnie znajduj si
   // na lewym i prawym kracu,
   // a wszystkie zostan sprawdzone,
   // lub a do znalezienia niezgodnych elementw.
   while(right > left)
   {
      if(str[left++] != str[right--])
      {
         return false;
      }
   }

   // Jeli wszystkie porwnane znaki
   // s jednakowe, cig musi by palindromem.
   return true;
   // --- Koniec wykrywacza palindromw ---
}

int main()
{
   setlocale( LC_ALL, "" );
   
   cout << "Palindrom" << endl;

   // Wprowadza cig znakowy.
   string str;
   cout << "Cig wejciowy -> ";
   getline(cin, str);

   // Sprawdza, czy jest palindromem.
   cout << "'" << str << "' to ";
   if(IsPalindrome(str))
   {
      cout << "palindrom";
   }
   else
   {
      cout << "NIE palindrom";
   }
   cout << endl;

   return 0;
}
