// Projekt: Interpolation_Search.cbp
// Plik   : Interpolation_Search.cpp

#include <iostream>

using namespace std;

int InterpolationSearch(
   int arr[],
   int lowIndex,
   int highIndex,
   int val)
{
   if(lowIndex <= highIndex)
   {
      // Oblicza indeks rodkowy.
      int middleIndex =
         lowIndex + (
             (val - arr[lowIndex]) * (highIndex - lowIndex) /
             (arr[highIndex] - arr[lowIndex]));

      // Jeli warto indeksu rodkowego jest rwna wyszukiwanej wartoci,
      // zwraca indeks.
      if(arr[middleIndex] == val)
      {
         return middleIndex;
      }
      // Jeli warto indeksu rodkowego jest wysza od wyszukiwanej,
      // wykonuje kolejne wyszukiwanie przez interpolacj w lewej podtablicy.
      // arr[lowIndex ... middleIndex - 1]
      else if(arr[middleIndex] > val)
      {
         return InterpolationSearch(arr, lowIndex, middleIndex - 1, val);
      }
      // Jeli warto indeksu rodkowego jest nisza od wyszukiwanej,
      // wykonuje kolejne wyszukiwanie przez interpolacj w prawej podtablicy.
      // arr[middleIndex + 1 ... highIndex]
      else
      {
         return InterpolationSearch(arr, middleIndex + 1, highIndex, val);
      }
   }

   // W przypadku, gdyby nie znaleziono adnej wartoci:
   return -1;
}

int main()
{
   cout << "Wyszukiwanie interpolacyjne" << endl;

   // Inicjalizuje now tablic.
   int arr[] = {3, 8, 11, 15, 16, 23, 28, 30, 32, 39, 42, 44, 47, 48, 50};
   int arrSize = sizeof(arr)/sizeof(*arr);

   // Definiuje warto do wyszukania.
   int searchedValue = 16;

   // Wyszukuje wskazan warto przy uyciu InterpolationSearch().
   int i = InterpolationSearch(arr, 0, arrSize - 1, searchedValue);

   // Powiadamia uytkownika o wyniku,
   // jeeli wyszukiwana warto zostaa znaleziona
   // i funkcja nie zwrcia wyniku -1.
   if(i != -1)
   {
      cout << searchedValue << " znaleziono w indeksie ";
      cout << i << endl;
   }
   else
   {
      cout << "Nie znaleziono wartoci " << searchedValue;
      cout << endl;
   }

   return 0;
}
