


#include <assert.h>
#include <stdlib.h>
#include "Cluster.h"

Cluster::Cluster(): head(0) { }

Cluster::~Cluster()
{
	while (head) {
		ClusterItem* next = head->next;
		delete head;
		head = next;
	}
}

static Cluster* cp;

void* ClusterItem::operator new(size_t n, Cluster& c)
{
	cp = &c;
	return ::operator new(n);
}

ClusterItem::ClusterItem()
{
	assert(cp != 0);
	next = cp->head;
	cp->head = this;
	cp = 0;
}

void* ClusterItem::operator new(size_t)
{
	abort();
	return 0;
}
