


#include "Seq.h"
#include "Seq.c"
#include <iostream.h>

template<class T>
Seq<T> merge(const Seq<T>& x, const Seq<T>& y)
{
	// jeeli jeden obiekt Seq jest pusty, zwraca drugi
	if (!x) return y;
	if (!y) return x;

	// obydwa s niepuste; pobiera pierwsze elementy
	T xh = x.hd();
	T yh = y.hd();

	// porwnuje je
	if (xh < yh)
		return cons(xh, merge(x.tl(), y));
	return cons(yh, merge(x, y.tl()));
}

template<class T>
void split(Seq<T> x, Seq<T>& y, Seq<T>& z)
{
	while (x) {
		y.insert(x.hd());
		if (++x) {
			z.insert(x.hd());
			++x;
		}
	}
}

template<class T>
Seq<T> sort(const Seq<T>& x)
{
	if (!x || !x.tl())
		return x;

	Seq<T> p, q;

	split(x, p, q);
	return merge(sort(p), sort(q));
}

template<class T>
Seq<T> merge2(Seq<T> x, Seq<T> y)
{
	Seq<T> r;

	while (x && y) {
		if (x.hd() < y.hd()) {
			r.insert(x.hd());
			x++;
		} else {
			r.insert(y.hd());
			y++;
		}
	}

	while (x) {
		r.insert(x.hd());
		x++;
	}

	while (y) {
		r.insert(y.hd());
		y++;
	}

	r.flip();
	return r;
}

main()
{
	Seq<int> si;
	si.insert(5);
	si.insert(3);
	si.insert(9);
	si.insert(2);
	si.insert(1);
	si.insert(7);
	si.insert(8);
	si.insert(0);
	si.insert(4);
	si.insert(6);
	Seq<int> s2 = sort(si);
	while (s2)
		cout << *s2++;
	cout << endl;
	cout << "0123456789" << endl;
	return 0;
}
