// rtti1.cpp -- Uywanie operatora dynamic_cast
#include <iostream>
#include <cstdlib>
#include <ctime>

using std::cout;

class Grand
{
private:
   int hold;
public:
   Grand(int h = 0) : hold(h) {}
   virtual void Speak() const { cout << "Jestem klasa Grand!\n"; }
   virtual int Value() const { return hold; }
};

class Superb : public Grand
{
public:
   Superb(int h = 0) : Grand(h) {}
   void Speak() const { cout << "Jestem klasa Superb!!\n"; }
   virtual void Say() const
      { cout << "Przechowuj warto klasy Superb, ktra wynosi " << Value() << "!\n";}
};

class Magnificent : public Superb
{
private:
   char ch;
public:
   Magnificent(int h = 0, char c = 'A') : Superb(h), ch(c) {}
   void Speak() const { cout << "Jestem klasa Magnificent!!!\n"; }
   void Say() const { cout << "Przechowuj znak " << ch <<
                    " oraz liczb " << Value() << "!\n"; }
};

Grand * GetOne();

int main()
{
   std::srand(std::time(0));
   Grand * pg;
   Superb * ps;
   for (int i = 0; i < 5; i++)
   {
      pg = GetOne();
      pg->Speak();
      if (ps = dynamic_cast<Superb *>(pg))
         ps->Say();
   }
   return 0;
}

Grand * GetOne() // Generuje losowo jeden z trzech rodzajw obiektw
{
   Grand * p;
   switch (std::rand() % 3)
   {
   case 0: p = new Grand(std::rand() % 100);
           break;
   case 1: p = new Superb(std::rand() % 100);
           break;
   case 2: p = new Magnificent(std::rand() % 100,
              'A' + std::rand() % 26);
           break;
   }
   return p;
}

