// studenti.h -- Klasa Student zdefiniowana za pomoc dziedziczenia wielokrotnego
#ifndef STUDENTC_H_
#define STUDENTC_H_

#include <iostream>
#include <valarray>
#include <string>
class Student : private std::string, private std::valarray<double>
{
private:
   typedef std::valarray<double> ArrayDb;
   // Prywatna metoda do wywietlania ocen
   std::ostream & arr_out(std::ostream & os) const;
public:
   Student() : std::string("Brak"), ArrayDb() {}
   Student(const std::string & s)
      : std::string(s), ArrayDb() {}
   Student(int n) : std::string("Brak"), ArrayDb(n) {}
   Student(const std::string & s, int n)
      : std::string(s), ArrayDb(n) {}
   Student(const std::string & s, const ArrayDb & a)
      : std::string(s), ArrayDb(a) {}
   Student(const char * str, const double * pd, int n)
      : std::string(str), ArrayDb(pd, n) {}
   ~Student() {}
   double Average() const;
   double & operator[](int i);
   double operator[](int i) const;
   const std::string & Name() const;
// Funkcje zaprzyjanione
   // Obsuga wejcia
   friend std::istream & operator>>(std::istream & is,
                                    Student & stu); // 1 sowo
   friend std::istream & getline(std::istream & is,
                                 Student & stu); // 1 linia
   // Obsuga wyjcia
   friend std::ostream & operator<<(std::ostream & os,
                                    const Student & stu);
};

#endif

