// strngbad.cpp -- implementacje metod klasy StringBad
#include <cstring>         // albo, gdzieniegdzie, string.h
#include "strngbad.h"
using std::cout;

// inicjalizacja statycznej skadowej klasy
int StringBad::num_strings = 0;

// metody klasy
// konstruuje obiekt StringBad na bazie cigu jzyka C
StringBad::StringBad(const char * s)
{
    len = std::strlen(s);    // ustalenie rozmiaru
    str = new char[len + 1]; // przydzia odpowiedniej iloci pamici
    std::strcpy(str, s);     // inicjalizacja wskanika
    num_strings++;           // uaktualnienie licznika obiektw
    cout << num_strings << ": \"" << str
         << "\" - obiekt utworzony.\n"; // komunikat diagnostyczny
}

StringBad::StringBad() // konstruktor domylny
{
    len = 4;
    str = new char[4];
    std::strcpy(str, "C++");          // cig domylny
    num_strings++;
    cout << num_strings << ": \"" << str
         << "\" - obiekt domylny utworzony.\n"; // komunikat diagnostyczny
}

StringBad::~StringBad() // niezbdny teraz destruktor
{
    cout << "\"" << str << "\" - obiekt usunity, ";    // diagnostyka
    --num_strings;                                      // konieczno
    cout << "s jeszcze " << num_strings << ".\n"; // diagnostyka
    delete [] str;                                      // konieczno
}

std::ostream & operator<<(std::ostream & os, const StringBad & st)
{
    os << st.str;
    return os;
}
