// sayings2.cpp -- stosowanie wskanikw obiektw
// kompilowa z plikiem string1.cpp
#include <iostream>
#include <cstdlib>   // (albo stdlib.h) - funkcje rand(), srand()
#include <ctime>     // (albo time.h) - funkcja time()
#include "string1.h"
const int ArSize = 10;
const int MaxLen = 81;

int main()
{
    using namespace std;
    String name;

    cout << "Cze, jak masz na imi?\n>> ";
    cin >> name;

    cout << name << ", wpisz do " << ArSize
        << " krtkich powiedzonek <pusty wiersz koczy wprowadzanie>:\n";
    String sayings[ArSize];
    char temp[MaxLen];       // tymczasowy obiekt cigu
    int i;
    for (i = 0; i < ArSize; i++)
    {
        cout << i+1 << ": ";
        cin.get(temp, MaxLen);
        while (cin && cin.get() != '\n')
            continue;
        if (!cin || temp[0] == '\0')     // czyby pusty wiersz?
            break;                       // bez zwikszania i
        else
            sayings[i] = temp;           // przecione przypisanie
    }
    int total = i;                       // czna liczba wczytanych wierszy

    if (total > 0)
    {
        cout << "Oto Twoje powiedzonka:\n";
        for (i = 0; i < total; i++)
            cout << sayings[i] << "\n";

        // wskaniki wskazujce szukane cigi
        String * shortest = &sayings[0]; // inicjalizacja pierwszym obiektem
        String * first = &sayings[0];
        for (i = 1; i < total; i++)
        {
            if (sayings[i].length() < shortest->length())
                shortest = &sayings[i];
            if (sayings[i] < *first)         // porwnanie wartoci
                first = &sayings[i];         // skopiowanie adresu
        }

        cout << "Najkrtsze powiedzonko:\n" << *shortest << endl;
        cout << "Powiedzonko alfabetycznie pierwsze:\n" << *first << endl;

        srand(time(0));
        int choice = rand() % total;    // wybierz liczb losow
        // wywoanie operatora new do przydziau nowego obiektu
        String * favorite = new String(sayings[choice]);
        cout << "Moje ulubione powiedzonko:\n" << *favorite << endl;
        delete favorite;
    }
    else
        cout << "Nie ma o czym gada, co?\n";

    cout << "egnam.\n";

    return 0;
}
