// usestock2.cpp -- testowanie klasy Stock
// kompilowa z plikiem stock2.cpp
#include <iostream>
#include "stock2.h"

const int STKS = 4;

int main()
{
    using std::cout;
    using std::ios_base;

    // utwrz tablic zainicjalizowanych obiektw
    Stock stocks[STKS] = {
        Stock("NanoSmart", 12, 20.0),
        Stock("BurakPOL", 200, 2.0),
        Stock("GruzPOL", 130, 3.25),
        Stock("FutroPOL", 60, 6.5)
    };

    cout.precision(2);                                 // format #.##
    cout.setf(ios_base::fixed, ios_base::floatfield);  // format #.##
    cout.setf(ios_base::showpoint);                    // format #.##

    cout << "Posiadane walory:/n";
    int st;
    for (st = 0; st < STKS; st++)
        stocks[st].show();

    Stock top = stocks[0];
    for (st = 0; st < STKS; st++)
        top = top.topval(stocks[st]);
    cout << "\nNajbardziej wartociowe udziay:\n";
    top.show();

    return 0;
}

