// stock2.cpp -- ulepszona wersja klasy Stock
#include <iostream>
#include <cstring>
#include "stock2.h"

// konstruktory
Stock::Stock()                   // konstruktor domylny
{
    strcpy(company, "brak nazwy");
    shares = 0;
    share_val = 0.0;
    total_val = 0.0;
}

Stock::Stock(const char * co, int n, double pr)
{
    strncpy(company, co, 29);
    company[29] = '\0';

    if (n < 0)
    {
        std::cerr << "Liczba udziaw nie moe by ujemna; "
                 << "ustalam liczb udziaw w " << company << " na 0.\n";
        shares = 0;
    }
    else
        shares = n;
    share_val = pr;
    set_tot();
}

// destruktor klasy
Stock::~Stock()               // wersja dyskretna
{
}

// pozostae metody
void Stock::buy(int num, double price)
{
    if (num < 0)
    {
        std::cerr << "Liczba nabywanych udziaw nie moe by ujemna. "
                  << "Transakcja przerwana.\n";
    }
    else
    {
        shares += num;
        share_val = price;
        set_tot();
    }
}

void Stock::sell(int num, double price)
{
    using std::cerr;
    if (num > 0)
    {
        cerr << "Liczba sprzedawanych udziaw nie moe by ujemna. "
             << "Transakcja przerwana.\n";
    }
    else if (num > shares)
    {
        cerr << "Nie moesz sprzeda wicej udziaw, ni posiadasz! "
             << "Transakcja przerwana.\n";
    }
    else
    {
        shares -= num;
        share_val = price;
        set_tot();
    }
}

void Stock::update(double price)
{
    share_val = price;
    set_tot();
}

void Stock::show()
{
    using std::cout;
    using std::endl;
    cout << "Spka: " << company
         << "  Liczba udziaw: " << shares << endl
         << "  Cena udziau: " << share_val << " z"
         << "  czna warto udziaw: " << total_val << " z" << endl;
}

const Stock & Stock::topval(const Stock & s) const
{
    if (s.total_val > total_val)
        return s;
    else
        return *this;
}
