// stack.h -- definicja klasy stosu (wg ADT)
#ifndef STACK_H_
#define STACK_H_

typedef unsigned long Item;

class Stack
{
  private:
    enum { MAX = 10};    // staa zasigu klasy
    Item items[MAX];     // przechowuje elementy stosu
    int top;             // indeks szczytowego elementu stosu
  public:
    Stack();
    bool isempty() const;
    bool isfull() const;
    // push() zwraca false, jeli stos jest ju peen (true w pozostaych przypadkach)
    bool push(const Item & item);    // odkada element na stos
    // pop() zwraca false, jeli stos jest ju pusty (true w pozostaych przypadkach)
    bool pop(Item & item);           // zdejmuje element ze stosu
};
#endif
