// lotto.cpp -- prawdopodobiestwo wygranej
#include <iostream>
// Uwaga: w niektrych implementacjach C++ trzeba uy typu double 
//        zamiast long double.
long double probability(unsigned numbers, unsigned picks);
int main()
{
    using namespace std;
    double total, choices;
    cout << "Podaj najwiksz liczb, jak mona wybra, oraz\n"
            "liczb skrele:\n";
    while ((cin >> total >> choices) && choices <= total)
    {
        cout << "Szansa wygranej to jeden do ";
        cout << probability(total, choices);      // wyliczenie wyniku
        cout << ".\n";
        cout << "Nastpne dwie liczby (q aby zakoczy): ";
    }
    cout << "do widzenia\n";
    return 0;
}

// Ponisza funkcja wylicza prawdopodobiestwo trafnego wybrania picks 
// liczb spord numbers moliwych.
long double probability(unsigned numbers, unsigned picks)
{
    long double result = 1.0;  // kilka zmiennych lokalnych
    long double n;
    unsigned p;

    for (n = numbers, p = picks; p > 0; n--, p--)
        result = result * n / p ; 
    return result;
}

