// random.cpp -- dostp swobodny do pliku binarnego
#include <iostream>	    // nie jest wymagane w przypadku wikszoci systemw 
#include <fstream>
#include <iomanip>
#include <cstdlib>		// ze wzgldu na funkcj exit()
const int LIM = 20;
struct planet
{
    char name[LIM];        // nazwa planety
    double population;     // zaludnienie
    double g;              // przyspieszenie grawitacyjne
};

const char * file = "planety.dat";  // Z ZAOENIA ISTNIEJE (przykad binary.cpp)
inline void eatline() { while (std::cin.get() != '\n') continue; }

int main()
{
    using namespace std;
	planet pl;
	cout << fixed;

// poka pocztkow zawarto
	fstream finout; 			// strumienie do odczytu i zapisu
	finout.open(file,
        ios_base::in | ios_base::out | ios_base::binary);
	//UWAGA: niektre systemy Unix wymagaj pominicia czonu | ios_base::binary
	int ct = 0;
	if (finout.is_open())
	{
		finout.seekg(0);		// przejd na pocztek
        cout << "Oto aktualna zawarto pliku "
		      << file << ":\n";
		while (finout.read((char *) &pl, sizeof pl))
		{
			cout << ct++ << ": " << setw(LIM) << pl.name << ": "
			<< setprecision(0) << setw(12) << pl.population
			<< setprecision(2) << setw(6) << pl.g << endl;
		}
		if (finout.eof())
			finout.clear();         // skasuj znacznik koca pliku
		else
		{
			cerr << "Bd przy prbie odczytu pliku " << file << ".\n";
			exit(EXIT_FAILURE);
		}
	}
	else
	{
        cerr << "Nie mona otworzy pliku " << file << " -- koniec pracy programu.\n";
        exit(EXIT_FAILURE);
    }

// zmie rekord
	cout << "Podaj numer rekordu, ktry chcesz zmieni: ";
	long rec;
	cin >> rec;
    eatline();
	if (rec < 0 || rec >= ct)
	{
		cerr << "Nieprawidowy numer rekordu -- koniec pracy programu\n";
		exit(EXIT_FAILURE);
    }
	streampos place = rec * sizeof pl;	// konwertuj na typ streampos
	finout.seekg(place);                // dostp swobodny
	if (finout.fail())
	{
		cerr << "Bd podczas wyszukiwania pozycji\n";
		exit(EXIT_FAILURE);
	}

	finout.read((char *) &pl, sizeof pl);
	cout << "Twj wybr:\n";
	cout << rec << ": " << setw(LIM) << pl.name << ": "
	     << setprecision(0) << setw(12) << pl.population
	     << setprecision(2) << setw(6) << pl.g << endl;
    if (finout.eof())
		finout.clear();         		// skasuj znacznik koca pliku

	cout << "Podaj nazw planety: ";
	cin.get(pl.name, LIM);
	cout << "Podaj zaludnienie planety: ";
	cin >> pl.population;
	cout << "Podaj przyspieszenie grawitacyjne na planecie: ";
	cin >> pl.g;
	finout.seekp(place);                // wr
	finout.write((char *) &pl, sizeof pl) << flush;
	if (finout.fail())
	{
		cerr << "Bd przy prbie zapisu\n";
		exit(EXIT_FAILURE);
	}

// wywietl zmieniony plik
    ct = 0;
	finout.seekg(0);			// przejd na pocztek pliku
	cout << "Oto nowa zawarto pliku " << file
	     << " :\n";
	while (finout.read((char *) &pl, sizeof pl))
    {
		cout << ct++ << ": " << setw(LIM) << pl.name << ": "
		     << setprecision(0) << setw(12) << pl.population
		     << setprecision(2) << setw(6) << pl.g << endl;
	}
	finout.close();
    cout << "Koniec.\n";
	return 0;
}