// binary.cpp -- zapis i odczyt pliku binarnego
#include <iostream>	// nie jest wymagane w przypadku wikszoci systemw 
#include <fstream>
#include <iomanip>
#include <cstdlib>		// (lub stdlib.h) ze wzgldu na funkcj exit()

inline void eatline() { while (std::cin.get() != '\n') continue; }
struct planet
{
    char name[20];        // nazwa planety
    double population;     // zaludnienie
    double g;              // przyspieszenie grawitacyjne
};

const char * file = "planety.dat";

int main()
{
    using namespace std;
	planet pl;
	cout << fixed << right;

// poka pocztkow zawarto
	ifstream fin;
	fin.open(file, ios_base::in |ios_base::binary);		// plik binarny
	//UWAGA: niektre systemy nie obsuguj trybu ios::binary
	if (fin.is_open())
	{
	cout << "Oto aktualna zawarto pliku "
		<< file << " file:\n";
	while (fin.read((char *) &pl, sizeof pl))
    {
		cout << setw(20) << pl.name << ": "
		      << setprecision(0) << setw(12) << pl.population
		      << setprecision(2) << setw(6) << pl.g << endl;
    }
	fin.close();
    }
	
// dodaj nowe dane
	ofstream fout(file, 
        ios_base::out | ios_base::app | ios_base::binary);
	//UWAGA: niektre systemy nie obsuguj trybu ios::binary
	if (!fout.is_open())
	{
        cerr << "Nie mona otworzy pliku " << file << " do zapisu.\n";
		exit(EXIT_FAILURE);
    }

	cout << "Podaj nazw planety (aby zakoczy, wprowad pusty wiersz):\n";
	cin.get(pl.name, 20);
	while (pl.name[0] != '\0')
    {
		cout << "Podaj zaludnienie planety: ";
		cin >> pl.population;
		cout << "Podaj przyspieszenie grawitacyjne na planecie: ";
		cin >> pl.g;
        eatline();
		fout.write((char *) &pl, sizeof pl);
        cout << "Podaj nazw planety (aby zakoczy, wprowad pusty wiersz):\n";
		cin.get(pl.name, 20);
	}
	fout.close();

// wywietl zmieniony plik
	fin.clear();	// instrukcja nie jest konieczna w przypadku niektrych kompilatorw
	fin.open(file, ios_base::in | ios_base::binary);
	if (fin.is_open())
	{
		cout << "Oto nowa zawarto pliku "
			 << file << ":\n";
	    while (fin.read((char *) &pl, sizeof pl))
        {
    		cout << setw(20) << pl.name << ": "
	    	     << setprecision(0) << setw(12) << pl.population
		         << setprecision(2) << setw(6) << pl.g << endl;
        }
    	fin.close();
    }
    cout << "Koniec.\n";
	return 0;
}

