// vect3.cpp -- Uycie funkcji biblioteki STL
#include <iostream>
#include <string>
#include <vector>
#include <algorithm>

struct Review {
   std::string title;
   int rating;
};

bool operator<(const Review & r1, const Review & r2);
bool worseThen(const Review & r1, const Review & r2);
bool FillReview(Review & rr);
void ShowReview(const Review & rr);
int main()
{
   using namespace std;

   vector<Review> books;
   Review temp;
   while (FillReview(temp))
      books.push_back(temp);
   cout << "Dzikuj. Podae "
        << books.size() << " ocen ksiek:\n"
        << "Ocena\tKsika\n";
   for_each(books.begin(), books.end(), ShowReview);

   sort(books.begin(), books.end());
   cout << "Posortowane wedug tytuu:\nOcena\tKsika\n";
   for_each(books.begin(), books.end(), ShowReview);

   sort(books.begin(), books.end(), worseThen);
   cout << "Posortowane wedug oceny:\nOcena\tKsika\n";
   for_each(books.begin(), books.end(), ShowReview);

   random_shuffle(books.begin(), books.end());
   cout << "Po wymieszaniu:\nOcena\tKsika\n";
   for_each(books.begin(), books.end(), ShowReview);
   cout << "Koniec.\n";
   return 0;
}

bool operator<(const Review & r1, const Review & r2)
{
   if (r1.title < r2.title)
      return true;
   else if (r1.title == r2.title && r1.rating < r2.rating)
      return true;
   else
      return false;
}

bool worseThan(const Review & r1, const Review & r2)
{
   if (r1.rating < r2.rating)
      return true;
   else
      return false;
}

bool FillReview(Review & rr)
{
   std::cout << " Wpisz tytu ksiki (koniec aby zakoczy): ";
   std::getline(std::cin, rr.title);
   if (rr.title == "koniec")
      return false;
   std::cout << "Wpisz ocen: ";
   std::cin >> rr.rating;
   if (!std::cin)
      return false;
   std::cin.get();
   return true;
}

void ShowReview(const Review & rr)
{
   std::cout << rr.rating << "\t" << rr.title << std::endl;
}

