// usealgo.cpp -- Uywanie rnych elementw biblioteki STL
#include <iostream>
#include <string>
#include <vector>
#include <set>
#include <map>
#include <iterator>
#include <algorithm>
#include <cctype>
using namespace std;

char toLower(char ch) { return tolower(ch); }
string & ToLower(string & st);
void display(const string & s);

int main()
{
   vector<string> words;
   cout << "Podaj sowa (koniec aby zakoczy):\n";
   string input;
   while (cin >> input && input != "koniec")
      words.push_back(input);
 
   cout << "Podae nastpujce sowa:\n";
   for_each(words.begin(), words.end(), display);
   cout << endl;

   // Umieszcza sowa w zbiorze przeksztacajc due litery na mae
   set<string> wordset;
   transform(words.begin(), words.end(),
      insert_iterator<set<string> >(wordset, wordset.begin()),
      ToLower);
   cout << "\nAlfabetyczna lista sw:\n";
   for_each(wordset.begin(), wordset.end(), display);
   cout << endl;

   // Umieszcza sowa i liczb ich wystpie w kontenerze map
   map<string, int> wordmap;
   set<string>::iterator si;
   for (si = wordset.begin(); si != wordset.end(); si++)
      wordmap[*si] = count(words.begin(), words.end(), *si);

   // Wywietla zawarto kontenera map
   cout << "\nLiczba wystpie sw:\n";
   for (si = wordset.begin(); si != wordset.end(); si++)
      cout << *si << ": " << wordmap[*si] << endl;

   return 0;
}

string & ToLower(string & st)
{
   transform(st.begin(), st.end(), st.begin(), toLower);
   return st;
}

void display(const string & s)
{
   cout << s << " ";
}

