// queue.h -- Szablon Queue z klas zagniedon
#ifndef QUEUETP_H_
#define QUEUETP_H_

template <class Item>
class QueueTP
{
private:
   enum {Q_SIZE = 10};
   // Definicja klasy zagniedonej Node
   class Node
   {
   public:
      Item item;
      Node * next;
      Node(const Item & i) : item(i), next(0) {}
   };
   Node * front; // Wskanik na przd kolejki
   Node * rear; // Wskanik na ty kolejki
   int items; // Aktualna liczba elementw w kolejce
   const int qsize; // Maksymalna liczba elementw w kolejce
   QueueTP(const QueueTP & q) : qsize(0) {}
   QueueTP & operator=(const QueueTP & q) { return *this; }
public:
   QueueTP(int us = Q_SIZE);
   ~QueueTP();
   bool isempty() const
   {
      return items == 0;
   }
   bool isfull() const
   {
      return items == qsize;
   }
   int queuecount() const
   {
      return items;
   }
   bool enqueue(const Item & item); // Dodaje element na koniec kolejki
   bool dequeue(Item & item); // Usuwa element z pocztku kolejki
};

// Metody klasy QueueTP
template <class Item>
QueueTP<Item>::QueueTP(int qs) : qsize(qs)
{
   front = rear = 0;
   items = 0;
}

template <class Item>
QueueTP<Item>::~QueueTP()
{
   Node * temp;
   while (front != 0) // Dopki kolejka nie jest pusta
   {
      temp = front; // Zapisuje adres pocztku kolejki
      front = front->next; // Ustawia wskanik na nastpny element
      delete temp; // Usuwa dawny pocztek
   }
}

// Dodaje element do kolejki
template <class Item>
bool QueueTP<Item>::enqueue(const Item & item)
{
   if (isfull())
      return false;
   Node * add = new Node(item); // Tworzy element
   if (add == NULL)
      return false; // Jeli to niemoliwe, koczy dziaanie
   items++;
   if (front == 0) // Jeli kolejka jest pusta
      front = add; // Dodaje element na pocztek kolejki
   else
      rear->next = add; // W przeciwnym razie dodaje na koniec
   rear = add; // Koniec kolejki wskazuje na dodany element
   return true;
}

// Umieszcza pocztkowy element w obiekcie item i usuwa z kolejki
template <class Item>
bool QueueTP<Item>::dequeue(Item & item)
{
   if (front == 0)
      return false;
   item = front->item; // Ustawia item na pierwszy element kolejki
   items--;
   Node * temp = front; // Zapisuje adres pierwszego elementu
   front = front->next; // Ustawia pocztek na nastpny element
   delete temp; // Usuwa poprzedni pocztek
   if (items == 0)
      rear = 0;
   return true;
}

#endif

