// error5.cpp -- Rozwijanie stosu
#include <iostream>
#include <cmath> // lub math.h; uytkownicy systemu UNIX mog potrzebowa opcji -lm
#include <cstring>
#include "exc_mean.h"

class demo
{
private:
   char word[40];
public:
   demo (const char * str)
   {
      strcpy(word, str);
      std::cout << "Obiekt demo " << word << " utworzony\n";
   }
   ~demo()
   {
      std::cout << "Obiekt demo " << word << " usunity\n";
   }
   void show() const
   {
      std::cout << "Obiekt demo " << word << " yje\n";
   }
};

// Prototypy funkcji
double hmean(double a, double b) throw(bad_hmean);
double gmean(double a, double b) throw(bad_gmean);
double means(double a, double b) throw(bad_hmean, bad_gmean);

int main()
{
   using std::cout;
   using std::cin;
   using std::endl;

   double x, y, z;
   demo d1("z funkcji main()");
   cout << "Podaj dwie liczby: ";
   while (cin >> x >> y)
   {
      try {   // Pocztek bloku try
         z = means(x, y);
         cout << "rednia rednich liczb " << x << " i " << y
              << " wynosi " << z << endl;
         cout << "Podaj kolejn par liczb: ";
      }   // Koniec bloku try
      catch (bad_hmean & bg) // Pocztek bloku catch
      {
         bg.mesg();
         cout << "Sprbuj ponownie.\n";
         continue;
      }
      catch (bad_gmean & hg)
      {
         cout << hg.mesg();
         cout << "Uyte wartoci: " << hg.v1 << ", "
              << hg.v2 << endl;
         cout << "Niestety to koniec zabawy.\n";
         break;
      } // Koniec bloku catch
   }
   d1.show();
   cout << "Koniec\n";
   return 0;
}

double hmean(double a, double b) throw(bad_hmean)
{
   if (a == -b)
      throw bad_hmean(a, b);
   return 2.0 * a * b / (a + b);
}

double gmean(double a, double b) throw(bad_gmean)
{
   if (a < 0 || b < 0)
      throw bad_gmean(a, b);
   return sqrt(a * b);
}

double means(double a, double b) throw(bad_hmean, bad_gmean)
{
   double am, hm, gm;
   demo d2("z funkcji means()");
   am = (a + b) / 2.0; // rednia arytmetyczna
   try
   {
      hm = hmean(a, b);
      gm = gmean(a, b);
   }
   catch (bad_hmean & bg) // Pocztek bloku catch
   {
      bg.mesg();
      std::cout << "Przechwycony w means()\n";
      throw; // Ponownie zgasza wyjtek
   }
   d2.show();
   return (am + hm + gm) / 3.0;
}


