// winec.cpp  -- Klasa Wine wykorzystujca zawieranie
#include <iostream>
#include "winec.h"

using std::cin;
using std::cout;
using std::cerr;
using std::endl;


Wine::Wine(const char * l, int y, const int yr[], const int bot[])
  : label(l), years(y), data(ArrayInt(yr,y),ArrayInt(bot,y) )
{
}

Wine::Wine(const char * l, const ArrayInt & yr, const ArrayInt & bot)
  : label(l), years(yr.size()), data(ArrayInt(yr), ArrayInt(yr))
{
	if (yr.size() != bot.size())
	{
		cerr << "Niezgodne dane, rozmiar tablicy ustawiony na 0.\n";
		years = 0;
        data = PairArray(ArrayInt(),ArrayInt());
	}
	else
	{
		data.first() = yr;
		data.second() = bot;
	}
}
Wine::Wine(const char * l, const PairArray & yr_bot)
: label(l), years(yr_bot.first().size()), data(yr_bot)  { }


Wine::Wine(const char * l, int y) : label(l), years(y),
	data(ArrayInt(0,y),ArrayInt(0,y))
{}

void Wine::GetBottles()
{
	if (years < 1)
	{
		cout << "Brak pamieci dla danych\n";
		return;
	}

	cout << "Podaj " << label <<
			" dane dla " << years << " rocznikow:\n";
	for (int i = 0; i < years; i++)
	{
		cout << "Podaj rocznik: ";
		cin >> data.first()[i];
		cout << "Podaj liczbe butelek: ";
		cin >> data.second()[i];
	}
}


void Wine::Show() const
{
	cout << "Wino: " << label << endl;
	cout << "\tRocznik\tButelek\n";
	for (int i = 0; i < years; i++)
		cout << '\t' << data.first()[i] 
		     << '\t' << data.second()[i] << endl;
}
