// tmp2tmp.cpp -- Szablony zaprzyjanione z szablonem klasy
#include <iostream>
using std::cout;
using std::endl;

// Prototypy szablonw
template <typename T> void counts();
template <typename T> void reports(T &);

// Szablon klasy
template <typename TT>
class HasFriendT
{
private:
   TT item;
   static int ct;
public:
   HasFriendT(const TT & i) : item(i) { ct++; }
   ~HasFriendT() { ct--; }
   friend void counts<TT>();
   friend void report<>(HasFriendT<TT> &);
};

template <typename T>
int HasFriendT<T>::ct = 0;
// Definicje szablonw funkcji zaprzyjanionych
template <typename T>
void counts()
{
   cout << "Szablon size: " << sizeof(HasFriendT<T>) << "; ";
   cout << "Szablon counts(): " << HasFriendT<T>::ct << endl;
}

template <typename T>
void report(T & hf)
{
   cout << hf.item << endl;
}

int main()
{
   counts<int>();
   HasFriendT<int> hfi1(10);
   HasFriendT<int> hfi2(20);
   HasFriendT<double> hfdb(10.5);
   report(hfi1); // Tworzy funkcj report(HasFriendT<int> &)
   report(hfi2); // Tworzy funkcj report(HasFriendT<int> &)
   report(hfdb); // Tworzy funkcj report(HasFriendT<double> &)
   cout << "Wynik dziaania counts<int>():\n";
   counts<int>();
   cout << "Wynik dziaania counts<double>():\n";
   counts<double>();

   return 0;
}

