// studenti.cpp -- Klasa Student korzystajca z dziedziczenia prywatnego
#include "studenti.h"
using std::ostream;
using std::endl;
using std::istream;
using std::string;

// Metody publiczne
double Student::Average() const
{
   if (ArrayDb::size() > 0)
      return ArrayDb::sum()/ArrayDb::size();
   else
      return 0;
}

const string & Student::Name() const
{
   return (const string &) *this;
}

double & Student::operator[](int i)
{
   return ArrayDb::operator[](i); // Uywa funkcji ArrayDb::operator[]()
}

double Student::operator[](int i) const
{
   return ArrayDb::operator[](i);
}

// Metoda prywatna
ostream & Student::arr_out(ostream & os) const
{
   int i;
   int lim = ArrayDb::size();
   if (lim > 0)
   {
      for (i = 0; i < lim; i++)
      {
         os << ArrayDb::operator[](i) << " ";
         if (i % 5 == 4)
            os << endl;
      }
      if (i % 5 == 0)
         os << endl;
   }
   else
      os << " tablica jest pusta ";
   return os;
}

// Funkcje zaprzyjanione
// Uywa funkcji operator>>() klasy string
istream & operator>>(istream & is, Student & stu)
{
   is >> (string &)stu;
   return is;
}

// Uywa funkcji getline(ostream &, const string &) zaprzyjanionej z klas string
istream & getline(istream & is, Student & stu)
{
   getline(is, (string &)stu);
   return is;
}

// Uywa funkcji operator<<() klasy string
ostream & operator<<(ostream & os, const Student & stu)
{
   os << "Wyniki " << (const string &) stu << ":\n";
   stu.arr_out(os); // Uywa metody prywatnej do wywietlania ocen
   return os;
}

