// usebrass2.cpp -- Przyklad wykorzystania polimorfizmu
// Kompilacja z plikiem brass.cpp
#include <iostream>
#include "brass.h"
const int CLIENTS = 4;
const int LEN = 40;
int main()
{
   using std::cin;
   using std::cout;
   using std::endl;
   Brass * p_clients[CLIENTS];

   int i;
   for (i = 0; i < CLIENTS; i++)
   {
      char temp[LEN];
      long tempnum;
      double tempbal;
      char kind;
      cout << "Podaj imie i nazwisko klienta: ";
      cin.getline(temp, LEN);
      cout << "Podaj numer rachunku klienta: ";
      cin >> tempnum;
      cout << "Podaj poczatkowy stan konta: ";
      cin >> tempbal;
      cout << "Wpisz 1 dla rachunku Brass lub "
           << "2 dla rachunku BrassPlus: ";
      while (cin >> kind && (kind != '1' && kind != '2'))
         cout << "Wpisz 1 lub 2: ";
      if (kind == '1')
         p_clients[i] = new Brass(temp, tempnum, tempbal);
      else
      {
         double tmax, trate;
         cout << "Podaj limit debetu: ";
         cin >> tmax;
         cout << "Podaj stope oprocentowania "
              << "jako ulamek dziesietny: ";
         cin >> trate;
         p_clients[i] = new BrassPlus(temp, tempnum, tempbal,
                                      tmax, trate);
      }
      while (cin.get() != '\n')
         continue;
   }
   cout << endl;
   for (i = 0; i < CLIENTS; i++)
   {
      p_clients[i]->ViewAcct();
      cout << endl;
   }
   
   for (i = 0; i < CLIENTS; i++)
   {
      delete p_clients[i]; // Zwalnia pamie
   }
   cout << "Gotowe.\n";

   return 0;
}

