// brass.cpp -- bank account class methods
#include <iostream>
#include <cstring>
#include "brass.h"
using std::cout;
using std::ios_base;
using std::endl;
// Brass methods

Brass::Brass(const char *s, long an, double bal)
{
    strncpy(fullName, s, MAX - 1);
    fullName[MAX - 1] = '\0';
    acctNum = an;
    balance = bal;
}

void Brass::Deposit(double amt)
{
    if (amt < 0)
        cout << "Nie moesz wplacic ujemnej kwoty; "
             << "Wplata anulowana.\n";
    else
        balance += amt;
}

void Brass::Withdraw(double amt)
{
    if (amt < 0)
        cout << "Nie mozna wyplacic ujemnej kwoty; "
             << "Wypata anulowana.\n";
    else if (amt <= balance)
        balance -= amt;
    else
        cout << "Zadana wartosc" << amt
             << " zl przekracza dostepne srodki.\n"
             << "Wyplata anulowana.\n";
}
double Brass::Balance() const
{
    return balance;
}

void Brass::ViewAcct() const
{
 // ustawia format w postaci ###.##
    ios_base::fmtflags initialState =
        cout.setf(ios_base::fixed, ios_base::floatfield);
    cout.setf(ios_base::showpoint);
    cout.precision(2);
    cout << "Client: " << fullName << endl;
    cout << "Account Number: " << acctNum << endl;
    cout << "Balance: $" << balance << endl;
    cout.setf(initialState); // Przywraca pocztkowy format
}

// Metody klasy BrassPlus
BrassPlus::BrassPlus(const char *s, long an, double bal,
           double ml, double r) : Brass(s, an, bal)
{
    maxLoan = ml;
    owesBank = 0.0;
    rate = r;
}

BrassPlus::BrassPlus(const Brass & ba, double ml, double r)
           : Brass(ba)   // Uywa niejawnego konstruktora kopiujcego
{
    maxLoan = ml;
    owesBank = 0.0;
    rate = r;
}

// Redefinicja metody ViewAcct()
void BrassPlus::ViewAcct() const
{
    // ustawia format w postaci ###.##
    ios_base::fmtflags initialState =
        cout.setf(ios_base::fixed, ios_base::floatfield);
    cout.setf(ios_base::showpoint);
    cout.precision(2);

    Brass::ViewAcct();   // Wywietla podobiekt bazowy
    cout << "Limit debetu: " << maxLoan << " zl" << endl;
    cout << "Kwota zadluzenia: " << owesBank << " zl" << endl;
    cout << "Stopa oprocentowania: " << 100 * rate << "%\n";
    cout.setf(initialState); 
}

// Redefinicja metody Withdraw()
void BrassPlus::Withdraw(double amt)
{
    // ustawia format w postaci ###.##
    ios_base::fmtflags initialState =
        cout.setf(ios_base::fixed, ios_base::floatfield);
    cout.setf(ios_base::showpoint);
    cout.precision(2);

    double bal = Balance();
    if (amt <= bal)
        Brass::Withdraw(amt);
    else if ( amt <= bal + maxLoan - owesBank)
    {
        double advance = amt - bal;
        owesBank += advance * (1.0 + rate);
        cout << "Zadluzenie faktyczne: " << advance << " zl" << endl;
        cout << "Odsetki: " << advance * rate << " zl" << endl;
        Deposit(advance);
        Brass::Withdraw(amt);
    }
    else
        cout << "Przekroczony limit debetu. Operacja anulowana.\n";
    cout.setf(initialState); 
}
