// string1.h -- poprawiona i uzupeniona implementacja klasy reprezentujcej
// cigi znakw
#include <iostream>
using std::ostream;
using std::istream;

#ifndef STRING1_H_
#define STRING1_H_
class String
{
  private:
    char * str;             // wskanik cigu
    int len;                // dugo cigu
    static int num_strings; // liczba obiektw klasy
    static const int CINLIM = 80; // limit dugoci cigu na wejciu
  public:
    // konstruktory i pozostae metody klasy
    String(const char * s);   // konstruktor
    String();                 // konstruktor domylny
    String(const String &);   // konstruktor kopiujcy
    ~String();                // destruktor
    int length () const { return len; }
    // metody przeciajce operatory
    String & operator=(const String &);
    String & operator=(const char *);
    char & operator[](int i);
    const char & operator[](int i) const;
    // funkcje zaprzyjanione przeciajce operatory
    friend bool operator<(const String &st, const String &st2);
    friend bool operator>(const String &st1, const String &st2);
    friend bool operator==(const String &st, const String &st2);
    friend ostream & operator<<(ostream & os, const String & st);
    friend istream & operator>>(istream & is, String & st);
    // metoda statyczna
    static int HowMany();
};
#endif
