// string1.cpp -- implementacje metod klasy String
#include <cstring>    // albo string.h
#include "string1.h"  // wcza plik nagwkowy <iostream>
using std::cin;
using std::cout;

// inicjalizacja statycznej skadowej klasy
int String::num_strings = 0;

// metoda statyczna
int String::HowMany()
{
    return num_strings;
}

// metody klasy
String::String(const char * s)          // konstruuje obiekt String z cigu C
{
    len = std::strlen(s);               // ustawienie dugoci cigu
    str = new char[len + 1];            // przydzia pamici
    std::strcpy(str, s);                // inicjalizacja wskanika cigu
    num_strings++;                      // aktualizacja licznika obiektw
}

String::String()                        // konstruktor domylny
{
    len = 4;
    str = new char[1];
    str[0] = '\0';                      // domylny cig obiektw klasy
    num_strings++;
}

String::String(const String & st)
{
    num_strings++;                      // aktualizacja skadowej statycznej
    len = st.len;                       // ta sama dugo cigu
    str = new char [len + 1];           // przydzia pamici
    std::strcpy(str, st.str);           // skopiowanie cigu
}

String::~String()                        // destruktor (niezbdny)
{
    --num_strings;                       // koniecznie
    delete [] str;                       // koniecznie
}

// metody przeciajce operatory
// przypisywanie obiektu klasy String do innego obiektu tej klasy
String & String::operator=(const String & st)
{
    if (this == &st)
        return *this;
    delete [] str;
    len = st.len;
    str = new char[len + 1];
    std::strcpy(str, st.str);
    return *this;
}

// przypisywanie cigu C do obiektu klasy String
String & String::operator=(const char * s)
{
    delete [] str;
    len = std::strlen(s);
    str = new char[len + 1];
    std::strcpy(str, s);
    return *this;
}

// peny dostp do znakw cigu (dla obiektw zwykych)
char & String::operator[](int i)
{
    return str[i];
}

// dostp (do odczytu) do znakw cigu (dla obiektw const)
const char & String::operator[](int i) const
{
    return str[i];
}

// zaprzyjanione funkcje przeciajce operatory
bool operator<(const String &st1, const String &st2)
{
    return (std::strcmp(st1.str, st2.str) < 0);
}

bool operator>(const String &st1, const String &st2)
{
    return st2.str < st1.str;
}

bool operator==(const String &st1, const String &st2)
{
    return (std::strcmp(st1.str, st2.str) == 0);
}

// wyprowadzenie cigu na wyjcie
ostream & operator<<(ostream & os, const String & st)
{
    os << st.str;
    return os;
}

// wczytywanie cigu z wejcia (uproszczone)
istream & operator>>(istream & is, String & st)
{
    char temp[String::CINLIM];
    is.get(temp, String::CINLIM);
    if (is)
    st = temp;
    while (is && is.get() != '\n')
        continue;
    return is;
}
