// queue.h -- interfejs kolejki
#ifndef QUEUE_H_
#define QUEUE_H_

// ta kolejka bdzie przechowywaa elementy klasy Customer
class Customer
{
  private:
    long arrive;     // czas doczenia klienta do kolejki
    int processtime; // czas obsugi klienta
  public:
    Customer() { arrive = processtime = 0; }
    void set(long when);
    long when() const { return arrive; }
    int ptime() const { return processtime; }
};

typedef Customer Item;
class Queue
{
  private:
    // definicje zasigu klasy
    // Node to definicja zagniedona klasy, lokalna wzgdem tej klasy
    struct Node { Item item; struct Node * next;};
    enum {Q_SIZE = 10};
    // prywatne skadowe klasy
    Node * front;       // wskanik czoa kolejki
    Node * rear;        // wskanik ogona kolejki
    int items;          // bieca liczba elementw kolejki
    const int qsize;    // maksymalna liczba elementw kolejki
    // definicje blokujce publiczny dostp do operacji kopiowania
    Queue(const Queue & q) : qsize(0) { }
    Queue & operator=(const Queue & q) { return *this;}
  public:
    Queue(int qs = Q_SIZE);         // tworzy kolejk o pojemnoci qs
    ~Queue();
    bool isempty() const;
    bool isfull() const;
    int queuecount() const;
    bool enqueue(const Item &item); // dodaje element na koniec kolejki
    bool dequeue(Item &item);       // wyciga element z czo kolejki
};
#endif
