// queue.cpp -- implementacje metod klas Queue i Customer
#include "queue.h"
#include <cstdlib>   // (albo stdlib.h) - funkcja rand()

// metody klasy Queue
Queue::Queue(int qs) : qsize(qs)
{
    front = rear = NULL;
    items = 0;
}

Queue::~Queue()
{
    Node * temp;
    while (front != NULL)     // do wyczerpania kolejki
    {
        temp = front;         // zachowanie adresu elementu biecego
        front = front->next;  // przesunicie wskanika do elementu nastpnego
        delete temp;          // zwolnienie elementu spod zapamitanego adresu
    }
}

bool Queue::isempty() const
{
    return items == 0;
}

bool Queue::isfull() const
{
    return items == qsize;
}

int Queue::queuecount() const
{
    return items;
}

// dodaje element do kolejki
bool Queue::enqueue(const Item & item)
{
    if (isfull())
        return false;
    Node * add = new Node;     // utworzenie wza
    if (add == NULL)
        return false;          // brak moliwoci przydziau elementu
    add->item = item;          // ustawienie wskanikw wzw
    add->next = NULL;
    items++;
    if (front == NULL)         // jeli kolejka jest pusta,
        front = add;           // umie element na czele listy
    else
        rear->next = add;      // w przeciwnym przypadku docz do koca
    rear = add;                // rear wskazuje teraz nowy wze
    return true;
}

// kopiuje element czoowy kolejki do argumentu wywoania i isiwa go z kolejki
bool Queue::dequeue(Item & item)
{
    if (front == NULL)
        return false;
    item = front->item;    // skopiowanie do item pierwszego elementu z kolejki
    items--;
    Node * temp = front;   // zachowanie pooenia pierwszego elementu
    front = front->next;   // przestawienie wskanika front na nastpny element
    delete temp;           // usunicie dotychczasowego pierwszego elementu
    if (items == 0)
        rear = NULL;
    return true;
}

// metody klasy Customer

// kiedy klient trafia do kolejki zapamitywany jest biecy
// czas systemowy, losowany jest te czas obsugi klienta
// (z zakresu od 1 do 3)
void Customer::set(long when)
{
    processtime = rand() % 3 + 1;
    arrive = when;
}
