// bank.cpp -- test interfejsu klasy Queue
// kompilowa z plikiem queue.cpp
#include <iostream>
#include <cstdlib>             // funkcje rand() i srand()
#include <ctime>               // funkcja time()
#include "queue.h"
const int MIN_PER_HR = 60;
bool newcustomer(double x);    // czy dotar ju nastpny klient?

int main()
{
    using std::cin;
    using std::cout;
    using std::endl;
    using std::ios_base;
    // przygotowanie symulacji
    srand(time(0));  // inicjalizacja generatora liczb losowych

    cout << "Studium przypadku: bankomat Baku Stu Kas\n";
    cout << "Podaj maksymaln dugo kolejki: ";
    int qs;
    cin >> qs;
    Queue line(qs);            // w kolejce moe stan do qs klientw

    cout << "Podaj symulowany czas (w godzinach): ";
    int hours;                 // liczba godzin symulacji
    cin >> hours;
    // symulacja z jednominutow rozdzielczoci
    long cyclelimit = MIN_PER_HR * hours;       // liczba cykli

    cout << "Podaj redni liczb klientw na godzin: ";
    double perhour;            // rednia liczba nowych klientw na godzin
    cin >> perhour;
    double min_per_cust;       // redni odstp czasowy pomidzy klientami
    min_per_cust = MIN_PER_HR / perhour;

    Item temp;                 // dane nowego klienta
    long turnaways = 0;        // liczba klientw odesanych z kolejki
    long customers = 0;        // liczba klientw przyjtych do kolejki
    long served = 0;           // liczba klientw obsuonych w symulacji
    long sum_line = 0;         // czna liczba oczekujcych
    int wait_time = 0;         // czas do zwolnienia bankomatu
    long line_wait = 0;        // czny czas oczekiwania

    // rozpoczcie symulacji
    for (int cycle = 0; cycle < cyclelimit; cycle++)
    {
        if (newcustomer(min_per_cust))  // mamy nowego chtnego
        {
            if (line.isfull())
                turnaways++;
            else
            {
                customers++;
                temp.set(cycle);        // czas przybycia = nr cyklu
                line.enqueue(temp);     // doczenie klienta do kolejki
            }
        }
        if (wait_time <= 0 && !line.isempty())
        {
            line.dequeue (temp);        // nastpny do obsuenia
            wait_time = temp.ptime();   // czas obsugi = wait_time
            line_wait += cycle - temp.when();
            served++;
        }
        if (wait_time > 0)
            wait_time--;
        sum_line += line.queuecount();
    }

    // zestawienie wynikw
    if (customers > 0)
    {
        cout << " liczba klientw przyjtych: " << customers << endl;
        cout << "liczba klientw obsuonych: " << served << endl;
        cout << " liczba klientw odesanych: " << turnaways << endl;
        cout << "    rednia dugo kolejki: ";
        cout.precision(2);
        cout.setf(ios_base::fixed, ios_base::floatfield);
        cout.setf(ios_base::showpoint);
        cout << (double) sum_line / cyclelimit << endl;
        cout << "    redni czas oczekiwania: "
            << (double) line_wait / served << " minut\n";
    }
    else
        cout << "Brak klientw!\n";

    cout << "Gotowe!\n";

    return 0;
}

// x = redni odstp czasowy (w minutach) pomidzy potencjalnymi klientami
// jeli warto zwracana to true, w danej minucie pojawi si klient
bool newcustomer(double x)
{
    return (rand() * x / RAND_MAX < 1);
}
