// vect.h -- klasa Vector z operatorem << i przecznikiem trybu
#ifndef VECTOR_H_
#define VECTOR_H_
#include <iostream>
namespace VECTOR
{
    class Vector
    {
      private:
        double x;        // warto skadowej poziomej
        double y;        // warto skadowej pionowej
        double mag;      // dugo wektora
        double ang;      // kierunek wektora
        char mode;       // 'r' = tryb prostoktny, 'p' = tryb biegunowy
        // prywatne metody ustawiajce skadowe
        void set_mag();
        void set_ang();
        void set_x();
        void set_y();
      public:
        Vector();
        Vector(double n1, double n2, char form = 'r');
        void set(double n1, double n2, char form = 'r');
        ~Vector();
        double xval() const {return x;}      // zwraca warto skadowej x
        double yval() const {return y;}      // zwraca warto skadowej y
        double magval() const {return mag;}  // zwraca dugo
        double angval() const {return ang;}  // zwraca kt
        void polar_mode();    // ustawia tryb na 'p'
        void rect_mode();     // ustawia tryb na 'r'
        // metody przeciajce operatory
        Vector operator+(const Vector & b) const;
        Vector operator-(const Vector & b) const;
        Vector operator-() const;
        Vector operator*(double n) const;
        // funkcje zaprzyjanione
        friend Vector operator*(double n, const Vector & a);
        friend std::ostream & operator<<(std::ostream & os, const Vector & v);
    };
} // koniec przestrzeni nazw VECTOR
#endif
