// vect.cpp -- implementacje metod klasy Vector
#include <cmath>
#include "vect.h"        // wcza plik nagwkowy <iostream>

using std::cout;

namespace VECTOR
{
    const double Rad_to_deg = 57.2957795130823;
    // metody prywatne
    // oblicza dugo wektora ze skadowych x i y
    void Vector::set_mag()
    {
        mag = sqrt(x * x + y * y);
    }

    void Vector::set_ang()
    {
        if (x == 0.0 && y == 0.0)
            ang = 0.0;
        else
            ang = atan2(y, x);
    }

    // oblicza skadow x ze wsprzdnych biegunowych
    void Vector::set_x()
    {
        x = mag * cos(ang);
    }

    // oblicza skadow y ze wsprzdnych biegunowych
    void Vector::set_y()
    {
        y = mag * sin(ang);
    }

    // metody publiczne
    Vector::Vector()          // konstruktor domylny
    {
        x = y = mag = ang = 0.0;
        mode = 'r';
    }

    // konstruuje wektor o zadanych wsprzdnych biegunowych (w trybie 'p')
    // bd prostoktnych (w domylnym trybie 'r')
    Vector::Vector(double n1, double n2, char form)
    {
        mode = form;
        if (form == 'r')
        {
            x = n1;
            y = n2;
            set_mag();
            set_ang();
        }
        else if (form == 'p')
        {
            mag = n1;
            ang = n2 / Rad_to_deg;
            set_x();
            set_y();
        }
        else
        {
            cout << "Niepoprawna warto trzeciego argumentu Vector() -- ";
            cout << "zeruj wektor\n";
            x = y = mag = ang = 0.0;
            mode = 'r';
        }
    }

    // ustawia wartoci wektora dla zadanych wsprzdnych biegunowych ('p')
    // lub prostoktnych ('r' -- ryb domylny)
    void Vector::set(double n1, double n2, char form)
    {
        mode = form;
        if (form == 'r')
        {
            x = n1;
            y = n2;
            set_mag();
            set_ang();
        }
        else if (form == 'p')
        {
            mag = n1;
            ang = n2 / Rad_to_deg;
            set_x();
            set_y();
        }
        else
        {
            cout << "Niepoprawny trzeci argument set() -- ";
            cout << "zeruj wektor\n";
            x = y = mag = ang = 0.0;
            mode = 'r';
        }
    }

    Vector::~Vector()   // destruktor
    {
    }

    void Vector::polar_mode()  // przecza do reprezentacji biegunowej
    {
        mode = 'p';
    }

    void Vector::rect_mode()   // przecza do reprezentacji kartezjaskiej
    {
        mode = 'r';
    }

    // przecione operatory
    // dodawanie dwch wektorw
    Vector Vector::operator+(const Vector & b) const
    {
        return Vector(x + b.x, y + b.y);
    }

    // odejmowanie wektora b od wektora a
    Vector Vector::operator-(const Vector & b) const
    {
        return Vector(x - b.x, y - b.y);
    }

    // zmienia znak wektora
    Vector Vector::operator-() const
    {
        return Vector(-x, -y);
    }

    // mnoy wektor wywoujcy przez n
    Vector Vector::operator*(double n) const
    {
        return Vector(n * x, n * y);
    }

    // funkcje zaprzyjanione
    // mnoy n przez wektor a
    Vector operator*(double n, const Vector & a)
    {
        return a * n;
    }

    // wywietla wsprzdne wektora (prostoktne w trybie 'r',
    // biegunowe w trybie 'p'
    std::ostream & operator<<(std::ostream & os, const Vector & v)
    {
        if (v.mode == 'r')
            os << "(x,y) = (" << v.x << ", " << v.y << ")";
        else if (v.mode == 'p')
        {
            os << "(m,a) = (" << v.mag << ", "
               << v.ang * Rad_to_deg << ")";
        }
        else
            os << "Niepoprawny tryb reprezentacji obiektu wektora";
        return os;
    }
} // koniec przestrzeni nazw VECTOR
