// stocks.cpp -- kompletny program
#include <iostream>
#include <cstring>

class Stock    // deklaracja klasy
{
  private:
    char company[30];
    int shares;
    double share_val;
    double total_val;
    void set_tot() { total_val = shares * share_val; }
  public:
    void acquire(const char * co, int n, double pr);
    void buy(int num, double price);
    void sell(int num, double price);
    void update(double price);
    void show();
};    // wane: rednik koczcy deklaracj

void Stock::acquire(const char * co, int n, double pr)
{
    strncpy(company, co, 29);    // kopiowanie z obciciem do rozmiaru skadowej
    company[29] = '\0';
    if (n < 0)
    {
        std::cerr << "Liczba udziaw nie moe by ujemna; "
                 << "ustalam liczb udziaw w " << company << " na 0.\n";
        shares = 0;
    }
    else
        shares = n;
    share_val = pr;
    set_tot();
}

void Stock::buy(int num, double price)
{
    if (num < 0)
    {
        std::cerr << "Liczba nabywanych udziaw nie moe by ujemna. "
                  << "Transakcja przerwana.\n";
    }
    else
    {
        shares += num;
        share_val = price;
        set_tot();
    }
}

void Stock::sell(int num, double price)
{
    using std::cerr;
    if (num > 0)
    {
        cerr << "Liczba sprzedawanych udziaw nie moe by ujemna. "
             << "Transakcja przerwana.\n";
    }
    else if (num > shares)
    {
        cerr << "Nie moesz sprzeda wicej udziaw, ni posiadasz! "
             << "Transakcja przerwana.\n";
    }
    else
    {
        shares -= num;
        share_val = price;
        set_tot();
    }
}

void Stock::update(double price)
{
    share_val = price;
    set_tot();
}

void Stock::show()
{
    using std::cout;
    using std::endl;
    cout << "Spka: " << company
         << "  Liczba udziaw: " << shares << endl
         << "  Cena udziau: " << share_val << " z"
         << "  czna warto udziaw: " << total_val << " z" << endl;
}

int main()
{
    using std::cout;
    using std::ios_base;

    Stock stock1;
    stock1.acquire("NanoSmart", 20, 12.50);
    cout.setf(ios_base::fixed);              // format #.##
    cout.precision(2);                       // format #.##
    cout.setf(ios_base::showpoint);          // format #.##
    stock1.show();
    stock1.buy(15, 18.25);
    stock1.show();
    stock1.sell(400, 20.00);
    stock1.show();
    return 0;
}
