// newplace.cpp -- stosowanie miejscowej wersji operatora new
#include <iostream>
#include <new>       // plik nagwkowy miejscowej odmiany new

const int BUF = 512;
const int N = 5;
char buffer[BUF];    // obszar pamici do realizacji przydziaw

int main()
{
    using namespace std;

    double *pd1, *pd2;
    int i;
    cout << "Wywoanie new zwykego i miejscowego:\n";
    pd1 = new double[N];               // przydzia w pamici sterty
    pd2 = new (buffer) double[N];      // przydzia w pamici bufora
    for (i = 0; i < N; i++)
        pd2[i] = pd1[i] = 1000 + 20.0 * i;
    cout << "Adresy buforw:\n" << " sterta: " << pd1
         << "  pami statyczna: " << (void*) buffer << endl;
    cout << "Zawarto bufora:\n";
    for (i = 0; i < N; i++)
    {
        cout << pd1[i] << " pod adresem " << &pd1[i] << "; ";
        cout << pd2[i] << " pod adresem " << &pd2[i] << endl;
    }

    cout << "\nDrugie wywoanie zwykego i miejscowego new:\n";
    double *pd3, *pd4;
    pd3 = new double[N];
    pd4 = new (buffer) double[N];
    for (i = 0; i < N; i++)
        pd4[i] = pd3[i] = 1000 + 20.0 * i;
    cout << "Zawarto bufora:\n";
    for (i = 0; i < N; i++)
    {
        cout << pd3[i] << " pod adresem " << &pd3[i] << "; ";
        cout << pd4[i] << " pod adresem " << &pd4[i] << endl;
    }

    cout << "\nTrzecie wywoanie zwykego i miejscowego new:\n";
    delete [] pd1;
    pd1 = new double[N];
    pd2 = new (buffer + N * sizeof(double)) double[N];
    for (i = 0; i < N; i++)
        pd2[i] = pd1[i] = 1000 + 20.0 * i;
    cout << "Zawarto bufora:\n";
    for (i = 0; i < N; i++)
    {
        cout << pd1[i] << " pod adresem " << &pd1[i] << "; ";
        cout << pd2[i] << " pod adresem " << &pd2[i] << endl;
    }
    delete [] pd1;
    delete [] pd3;

    return 0;
}
