// strctptr.cpp -- funkcje ze wskanikami struktur jako parametrami
#include <iostream>
#include <cmath>

// structure templates
struct polar
{
    double distance;      // odlego od pocztku ukadu
    double angle;         // kierunek wzgldem dodatniej posi x
};
struct rect
{
    double x;             // odlego od pocztku ukadu w poziomie
    double y;             // odlego od pocztku ukadu w pionie
};

// prototypy
void rect_to_polar(const rect * pxy, polar * pda);
void show_polar (const polar * pda);

int main()
{
    using namespace std;
    rect rplace;
    polar pplace;

    cout << "Podaj wartoci x i y: ";
    while (cin >> rplace.x >> rplace.y)
    {
        rect_to_polar(&rplace, &pplace);    // przeka adres
        show_polar(&pplace);                // przeka adres
        cout << "Nastpna para liczb lub q, aby zakoczy: ";
    }
    cout << "Gotowe.\n";
    return 0;
}

// pokazuje wsprzdne biegunowe, zamienia radiany na stopnie
void show_polar (const polar * pda)
{
    using namespace std;
    const double Rad_to_deg = 57.29577951;

    cout << "odlego = " << pda->distance;
    cout << ", kt = " << pda->angle * Rad_to_deg;
    cout << " stopni\n";
}

// zamiana wsprzdnych prostoktnych na biegunowe
void rect_to_polar(const rect * pxy, polar * pda)
{
    using namespace std;
    pda->distance =
        sqrt(pxy->x * pxy->x + pxy->y * pxy->y);
    pda->angle = atan2(pxy->y, pxy->x);
}
