// strctfun.cpp -- funkcje majce struktur za parametr
#include <iostream>
#include <cmath>

// structure declarations
struct polar
{
    double distance;      // odlego od pocztku ukadu
    double angle;         // kt wzgldem dodatniej posi x
};
struct rect
{
    double x;             // odlego od pocztku ukadu w poziomie
    double y;             // odlego od pocztku ukadu w pionie
};

// prototypy
polar rect_to_polar(rect xypos);
void show_polar(polar dapos);

int main()
{
    using namespace std;
    rect rplace;
    polar pplace;

    cout << "Podaj wartoci x i y: ";
    while (cin >> rplace.x >> rplace.y)  // chytre uycie cin
    {
        pplace = rect_to_polar(rplace);
        show_polar(pplace);
        cout << "Podaj nastpne liczby lub q, aby zakoczy: ";
    }
    cout << "Gotowe.\n";
    return 0;
}

// zamienia wsprzdne prostoktne nabiegunowe
polar rect_to_polar(rect xypos)
{
    using namespace std;
    polar answer;

    answer.distance =
        sqrt( xypos.x * xypos.x + xypos.y * xypos.y);
    answer.angle = atan2(xypos.y, xypos.x);
    return answer;      // zwraca struktur polar
}

// pokazuje wsprzdne biegunowe, radiany przelicza na stopnie
void show_polar (polar dapos)
{
    using namespace std;
    const double Rad_to_deg = 57.29577951;

    cout << "odlego = " << dapos.distance;
    cout << ", kt = " << dapos.angle * Rad_to_deg;
    cout << " stopni\n";
}
