#include <exception>
#include <iostream>     // cout
#include <memory>       // auto_ptr
#include <vector>
#include <xercesc/sax2/SAX2XMLReader.hpp>
#include <xercesc/sax2/XMLReaderFactory.hpp>
#include <xercesc/util/PlatformUtils.hpp>
#include "animal.hpp"
#include "xerces_strings.hpp"  // listing 14-4

using namespace std;
using namespace xercesc;

// narzdzie RAII inicjalizujce analizator i zwalniajce zasoby
// przy wyjciu obiektu analizatora z zasigu
class XercesInitializer {
public:
    XercesInitializer( ) { XMLPlatformUtils::Initialize( ); }
    ~XercesInitializer( ) { XMLPlatformUtils::Terminate( ); }
private:
    // zablokowanie kopiowania i przypisywania
    XercesInitializer(const XercesInitializer&);
    XercesInitializer& operator=(const XercesInitializer&);
};

int main( )
{
    try {
        vector<Animal> animalList;

        // inicjalizacja Xerces i pozyskanie obiektu analizatora
        XercesInitializer        init; 
        auto_ptr<SAX2XMLReader>  ]
            parser(XMLReaderFactory::createXMLReader( ));

        // rejestrowanie klas obsugi
        CircusContentHandler     content(animalList);
        CircusErrorHandler       error;
        parser->setContentHandler(&content);
        parser->setErrorHandler(&error);

        // analiza dokumentu XML
        parser->parse("cyrk.xml");
       
        // wypisanie imion zwierzakw
        for ( vector<Animal>::size_type i = 0,
                                        n = animalList.size( );
              i < n;
              ++i )
        {
            cout << animalList[i] << "\n";
        }
    } catch (const SAXException& e) {
        cout << "bd xml: " << toNative(e.getMessage( )) << "\n";
        return EXIT_FAILURE;
    } catch (const XMLException& e) {
        cout << "bd xml: " << toNative(e.getMessage( )) << "\n";
        return EXIT_FAILURE;
    } catch (const exception& e) {
        cout << e.what( ) << "\n";
        return EXIT_FAILURE;
    }
}