#include <iostream>

using namespace std;

class Singleton {
public:
   // metoda udostpniajca klientom jedyny egzemplarz klasy
   static Singleton* getInstance( );

   void setValue(int val) {value_ = val;}
   int  getValue( )       {return(value_);}

protected:
   int value_;

private:
   static Singleton* inst_;    // jedyny egzemplarz klasy
   Singleton( ) : value_(0) {} // konstruktory s prywatne
   Singleton(const Singleton&);
   Singleton& operator=(const Singleton&);
};

// definicja statycznego wskanika jedynaka
Singleton* Singleton::inst_ = NULL;

Singleton* Singleton::getInstance( ) {
   if (inst_ == NULL) {
      inst_ = new Singleton( );
   }
   return(inst_);
}

int main( ) {

   Singleton* p1 = Singleton::getInstance( );

   p1->setValue(10);
    
   Singleton* p2 = Singleton::getInstance( );

   cout << "Warto = " << p2->getValue( ) << '\n';
}