#include <iostream>

class Session {};

class SessionFactory {

public:
   Session Create( );
   Session* CreatePtr( );
   void Create(Session*& p);
   // ...
};

// zwraca kopi obiektu tworzonego na stosie
Session SessionFactory::Create( ) {
   Session s;
   return(s);
}

// zwraca wskanik obiektu tworzonego na stercie
Session* SessionFactory::CreatePtr( ) {
   return(new Session( ));
}

// aktualizuje wskanik przekazany przez wywoujcego
// adresem nowotworzonego obiektu
void SessionFactory::Create(Session*& p) {
   p = new Session( );
}

static SessionFactory f; // globalny obiekt wytwarzajcy obiekty

int main( ) {
   Session* p1;
   Session* p2 = new Session( );

   *p2 = f.Create( );   // proste przypisanie obiektu zwracanego przez Create
   p1 = f.CreatePtr( ); // albo skopiowanie wskanika obiektu sterty
   f.Create(p1);        // albo aktualizacja wskanika nowym adresem
}