#include <iostream>
#include <string>
#include <hash_map>

using namespace std;

class Session { /* ... */ };

// synonim typu (dla wygody)
typedef hash_map<string, Session*> SessionHashMap;

class SessionManager {

public:
   SessionManager ( ) : sessionMap_(500) {}  // inicjalizacja tabeli haszowanej
                                             // 500-toma gniazdami
  ~SessionManager ( ) {
      for (SessionHashMap::iterator p = sessionMap_.begin( );
           p != sessionMap_.end( ); ++p)
         delete (*p).second; // usunicie obiektu sesji
   }

   Session* addSession(const string& login) {
      Session* p = NULL;
      if (!(p = getSession(login))) {
         p = new Session( );
         sessionMap_[login] = p; // przypisanie nowej sesji operatorem 
      }                          // indeksowania (operator[])
      return(p);
   }
   Session* getSession(const string& login) {
      return(sessionMap_[login]);
   }
   // ...

private:
   SessionHashMap sessionMap_;
};
